kDisSubsL:	.EQU 13	;Last operand substitution string
kDisSubNN:	.EQU 4	;Operand substitution string 'nn'
kDisSubC:	.EQU 10	;Operand substitution string 'c'
kDisSubCC:	.EQU 11	;Operand substitution string 'cc'
kDisBracHL:	.EQU 21	;Bracketed HL
kDisHL:	.EQU 24	;HL
kDisFlowF:	.EQU 27	;First flow control instructions
kDisFlowL:	.EQU 34	;Last flow control instructions
kDisJR:	.EQU 27	;Operation string 'JR'
kDisDJNZ:	.EQU 28	;Operation string 'DJNZ'
kDisRST:	.EQU 29	;Operation string 'RST'
kDisJP:	.EQU 30	;Operation string 'JP'
kDisCALL:	.EQU 31	;Operation string 'CALL'
kDisRET:	.EQU 32	;Operation string 'RET'
kDisOpMask:	.EQU 0x3F	;Operand 1 mask to exclude pre-code bits
kDisMskC:	.EQU 0x18	;Condition bit mask for Operand 1 = C
kDisMskCC:	.EQU 0x38	;Condition bit mask for Operand 1 = CC
kDisMskRST:	.EQU 0x38	;Restart address bits

DisString:
	.DB  0x80                              	;String 0x01 = 
	.DB  0x80+'n'                          	;String 0x02 = n
	.DB  0x80+'(',"n)"                     	;String 0x03 = (n)
	.DB  0x80+'n',"n"                      	;String 0x04 = nn
	.DB  0x80+'(',"nn)"                    	;String 0x05 = (nn)
	.DB  0x80+'r'                          	;String 0x06 = r
	.DB  0x80+'r',"2"                      	;String 0x07 = r2
	.DB  0x80+'d',"d"                      	;String 0x08 = dd
	.DB  0x80+'q',"q"                      	;String 0x09 = qq
	.DB  0x80+'c'                          	;String 0x0A = c
	.DB  0x80+'c',"c"                      	;String 0x0B = cc
	.DB  0x80+'t'                          	;String 0x0C = t
	.DB  0x80+'b'                          	;String 0x0D = b
	.DB  0x80+'B',"CDEHL-A"                	;String 0x0E = BCDEHL-A
	.DB  0x80+'B',"CDE**SP"                	;String 0x0F = BCDE**SP
	.DB  0x80+'B',"CDE**AF"                	;String 0x10 = BCDE**AF
	.DB  0x80+'N',"ZZ.NCC."                	;String 0x11 = NZZ.NCC.
	.DB  0x80+'N',"ZZ.NCC.POPEP.M."        	;String 0x12 = NZZ.NCC.POPEP.M.
	.DB  0x80+'0',"008101820283038"        	;String 0x13 = 0008101820283038
	.DB  0x80+'0',"1234567"                	;String 0x14 = 01234567
	.DB  0x80+'(',"HL)"                    	;String 0x15 = (HL)
	.DB  0x80+'(',"IX+"                    	;String 0x16 = (IX+
	.DB  0x80+'(',"IY+"                    	;String 0x17 = (IY+
	.DB  0x80+'H',"L"                      	;String 0x18 = HL
	.DB  0x80+'I',"X"                      	;String 0x19 = IX
	.DB  0x80+'I',"Y"                      	;String 0x1A = IY
	.DB  0x80+'J',"R"                      	;String 0x1B = JR
	.DB  0x80+'D',"JNZ"                    	;String 0x1C = DJNZ
	.DB  0x80+'R',"ST"                     	;String 0x1D = RST
	.DB  0x80+'J',"P"                      	;String 0x1E = JP
	.DB  0x80+'C',"ALL"                    	;String 0x1F = CALL
	.DB  0x80+'R',"ET"                     	;String 0x20 = RET
	.DB  0x80+'R',"ETI"                    	;String 0x21 = RETI
	.DB  0x80+'R',"ETN"                    	;String 0x22 = RETN
	.DB  0x80+'A'                          	;String 0x23 = A
	.DB  0x80+'(',"SP)"                    	;String 0x24 = (SP)
	.DB  0x80+'A',"F"                      	;String 0x25 = AF
	.DB  0x80+'D',"E"                      	;String 0x26 = DE
	.DB  0x80+'0'                          	;String 0x27 = 0
	.DB  0x80+'1'                          	;String 0x28 = 1
	.DB  0x80+'2'                          	;String 0x29 = 2
	.DB  0x80+'(',"BC)"                    	;String 0x2A = (BC)
	.DB  0x80+'(',"DE)"                    	;String 0x2B = (DE)
	.DB  0x80+'S',"P"                      	;String 0x2C = SP
	.DB  0x80+'I'                          	;String 0x2D = I
	.DB  0x80+'R'                          	;String 0x2E = R
	.DB  0x80+'(',"C)"                     	;String 0x2F = (C)
	.DB  0x80+'A',"F'"                     	;String 0x30 = AF'
	.DB  0x80+'A',"DC"                     	;String 0x31 = ADC
	.DB  0x80+'A',"DD"                     	;String 0x32 = ADD
	.DB  0x80+'A',"ND"                     	;String 0x33 = AND
	.DB  0x80+'B',"IT"                     	;String 0x34 = BIT
	.DB  0x80+'C',"CF"                     	;String 0x35 = CCF
	.DB  0x80+'C',"P"                      	;String 0x36 = CP
	.DB  0x80+'C',"PD"                     	;String 0x37 = CPD
	.DB  0x80+'C',"PDR"                    	;String 0x38 = CPDR
	.DB  0x80+'C',"PI"                     	;String 0x39 = CPI
	.DB  0x80+'C',"PIR"                    	;String 0x3A = CPIR
	.DB  0x80+'C',"PL"                     	;String 0x3B = CPL
	.DB  0x80+'D',"AA"                     	;String 0x3C = DAA
	.DB  0x80+'D',"EC"                     	;String 0x3D = DEC
	.DB  0x80+'D',"I"                      	;String 0x3E = DI
	.DB  0x80+'E',"I"                      	;String 0x3F = EI
	.DB  0x80+'E',"X"                      	;String 0x40 = EX
	.DB  0x80+'E',"XX"                     	;String 0x41 = EXX
	.DB  0x80+'H',"ALT"                    	;String 0x42 = HALT
	.DB  0x80+'I',"M"                      	;String 0x43 = IM
	.DB  0x80+'I',"N"                      	;String 0x44 = IN
	.DB  0x80+'I',"NC"                     	;String 0x45 = INC
	.DB  0x80+'I',"ND"                     	;String 0x46 = IND
	.DB  0x80+'I',"NDR"                    	;String 0x47 = INDR
	.DB  0x80+'I',"NI"                     	;String 0x48 = INI
	.DB  0x80+'I',"NIR"                    	;String 0x49 = INIR
	.DB  0x80+'L',"D"                      	;String 0x4A = LD
	.DB  0x80+'L',"DD"                     	;String 0x4B = LDD
	.DB  0x80+'L',"DDR"                    	;String 0x4C = LDDR
	.DB  0x80+'L',"DI"                     	;String 0x4D = LDI
	.DB  0x80+'L',"DIR"                    	;String 0x4E = LDIR
	.DB  0x80+'N',"EG"                     	;String 0x4F = NEG
	.DB  0x80+'N',"OP"                     	;String 0x50 = NOP
	.DB  0x80+'O',"R"                      	;String 0x51 = OR
	.DB  0x80+'O',"TDR"                    	;String 0x52 = OTDR
	.DB  0x80+'O',"TIR"                    	;String 0x53 = OTIR
	.DB  0x80+'O',"UT"                     	;String 0x54 = OUT
	.DB  0x80+'O',"UTD"                    	;String 0x55 = OUTD
	.DB  0x80+'O',"UTI"                    	;String 0x56 = OUTI
	.DB  0x80+'P',"OP"                     	;String 0x57 = POP
	.DB  0x80+'P',"USH"                    	;String 0x58 = PUSH
	.DB  0x80+'R',"ES"                     	;String 0x59 = RES
	.DB  0x80+'R',"L"                      	;String 0x5A = RL
	.DB  0x80+'R',"LA"                     	;String 0x5B = RLA
	.DB  0x80+'R',"LC"                     	;String 0x5C = RLC
	.DB  0x80+'R',"LCA"                    	;String 0x5D = RLCA
	.DB  0x80+'R',"LD"                     	;String 0x5E = RLD
	.DB  0x80+'R',"R"                      	;String 0x5F = RR
	.DB  0x80+'R',"RA"                     	;String 0x60 = RRA
	.DB  0x80+'R',"RC"                     	;String 0x61 = RRC
	.DB  0x80+'R',"RCA"                    	;String 0x62 = RRCA
	.DB  0x80+'R',"RD"                     	;String 0x63 = RRD
	.DB  0x80+'S',"BC"                     	;String 0x64 = SBC
	.DB  0x80+'S',"CF"                     	;String 0x65 = SCF
	.DB  0x80+'S',"ET"                     	;String 0x66 = SET
	.DB  0x80+'S',"LA"                     	;String 0x67 = SLA
	.DB  0x80+'S',"LL"                     	;String 0x68 = SLL
	.DB  0x80+'S',"RA"                     	;String 0x69 = SRA
	.DB  0x80+'S',"RL"                     	;String 0x6A = SRL
	.DB  0x80+'S',"UB"                     	;String 0x6B = SUB
	.DB  0x80+'X',"OR"                     	;String 0x6C = XOR
	.DB  0x80+'?',"???"                    	;String 0x6D = ????
	.DB  0x80

DisInst:
	.DB  0x88,0xF8,0x31,0x23,0x07 ;Opcode: 0x88 - ADC  A   ,r2  
	.DB  0xCE,0xFF,0x31,0x23,0x02 ;Opcode: 0xCE - ADC  A   ,n   
	.DB  0x4A,0xCF,0x31,0xD8,0x08 ;Opcode: 0x4A - ADC  HL  ,dd  
	.DB  0x80,0xF8,0x32,0x23,0x07 ;Opcode: 0x80 - ADD  A   ,r2  
	.DB  0xC6,0xFF,0x32,0x23,0x02 ;Opcode: 0xC6 - ADD  A   ,n   
	.DB  0x09,0xCF,0x32,0x18,0x08 ;Opcode: 0x09 - ADD  HL  ,dd  
	.DB  0xA0,0xF8,0x33,0x07,0x01 ;Opcode: 0xA0 - AND  r2  ,    
	.DB  0xE6,0xFF,0x33,0x02,0x01 ;Opcode: 0xE6 - AND  n   ,    
	.DB  0x40,0xC0,0x34,0x8D,0x07 ;Opcode: 0x40 - BIT  b   ,r2  
	.DB  0xC4,0xC7,0x1F,0x0B,0x04 ;Opcode: 0xC4 - CALL cc  ,nn  
	.DB  0xCD,0xFF,0x1F,0x04,0x01 ;Opcode: 0xCD - CALL nn  ,    
	.DB  0x3F,0xFF,0x35,0x01,0x01 ;Opcode: 0x3F - CCF      ,    
	.DB  0xB8,0xF8,0x36,0x07,0x01 ;Opcode: 0xB8 - CP   r2  ,    
	.DB  0xFE,0xFF,0x36,0x02,0x01 ;Opcode: 0xFE - CP   n   ,    
	.DB  0xA9,0xFF,0x37,0xC1,0x01 ;Opcode: 0xA9 - CPD      ,    
	.DB  0xB9,0xFF,0x38,0xC1,0x01 ;Opcode: 0xB9 - CPDR     ,    
	.DB  0xA1,0xFF,0x39,0xC1,0x01 ;Opcode: 0xA1 - CPI      ,    
	.DB  0xB1,0xFF,0x3A,0xC1,0x01 ;Opcode: 0xB1 - CPIR     ,    
	.DB  0x2F,0xFF,0x3B,0x01,0x01 ;Opcode: 0x2F - CPL      ,    
	.DB  0x27,0xFF,0x3C,0x01,0x01 ;Opcode: 0x27 - DAA      ,    
	.DB  0x0B,0xCF,0x3D,0x08,0x01 ;Opcode: 0x0B - DEC  dd  ,    
	.DB  0x05,0xC7,0x3D,0x06,0x01 ;Opcode: 0x05 - DEC  r   ,    
	.DB  0xF3,0xFF,0x3E,0x01,0x01 ;Opcode: 0xF3 - DI       ,    
	.DB  0x10,0xFF,0x1C,0x02,0x01 ;Opcode: 0x10 - DJNZ n   ,    
	.DB  0xFB,0xFF,0x3F,0x01,0x01 ;Opcode: 0xFB - EI       ,    
	.DB  0xE3,0xFF,0x40,0x24,0x18 ;Opcode: 0xE3 - EX   (SP),HL  
	.DB  0x08,0xFF,0x40,0x25,0x30 ;Opcode: 0x08 - EX   AF  ,AF' 
	.DB  0xEB,0xFF,0x40,0x26,0x18 ;Opcode: 0xEB - EX   DE  ,HL  
	.DB  0xD9,0xFF,0x41,0x01,0x01 ;Opcode: 0xD9 - EXX      ,    
	.DB  0x76,0xFF,0x42,0x01,0x01 ;Opcode: 0x76 - HALT     ,    
	.DB  0x46,0xFF,0x43,0xE7,0x01 ;Opcode: 0x46 - IM   0   ,    
	.DB  0x56,0xFF,0x43,0xE8,0x01 ;Opcode: 0x56 - IM   1   ,    
	.DB  0x5E,0xFF,0x43,0xE9,0x01 ;Opcode: 0x5E - IM   2   ,    
	.DB  0x40,0xC7,0x44,0xC6,0x2F ;Opcode: 0x40 - IN   r   ,(C) 
	.DB  0xDB,0xFF,0x44,0x23,0x03 ;Opcode: 0xDB - IN   A   ,(n) 
	.DB  0x03,0xCF,0x45,0x08,0x01 ;Opcode: 0x03 - INC  dd  ,    
	.DB  0x04,0xC7,0x45,0x06,0x01 ;Opcode: 0x04 - INC  r   ,    
	.DB  0xAA,0xFF,0x46,0xC1,0x01 ;Opcode: 0xAA - IND      ,    
	.DB  0xBA,0xFF,0x47,0xC1,0x01 ;Opcode: 0xBA - INDR     ,    
	.DB  0xA2,0xFF,0x48,0xC1,0x01 ;Opcode: 0xA2 - INI      ,    
	.DB  0xB2,0xFF,0x49,0xC1,0x01 ;Opcode: 0xB2 - INIR     ,    
	.DB  0xE9,0xFF,0x1E,0x15,0x01 ;Opcode: 0xE9 - JP   (HL),    
	.DB  0xC2,0xC7,0x1E,0x0B,0x04 ;Opcode: 0xC2 - JP   cc  ,nn  
	.DB  0xC3,0xFF,0x1E,0x04,0x01 ;Opcode: 0xC3 - JP   nn  ,    
	.DB  0x20,0xE7,0x1B,0x0A,0x02 ;Opcode: 0x20 - JR   c   ,n   
	.DB  0x18,0xFF,0x1B,0x02,0x01 ;Opcode: 0x18 - JR   n   ,    
	.DB  0x40,0xC0,0x4A,0x06,0x07 ;Opcode: 0x40 - LD   r   ,r2  
	.DB  0x02,0xFF,0x4A,0x2A,0x23 ;Opcode: 0x02 - LD   (BC),A   
	.DB  0x12,0xFF,0x4A,0x2B,0x23 ;Opcode: 0x12 - LD   (DE),A   
	.DB  0x32,0xFF,0x4A,0x05,0x23 ;Opcode: 0x32 - LD   (nn),A   
	.DB  0x22,0xFF,0x4A,0x05,0x18 ;Opcode: 0x22 - LD   (nn),HL  
	.DB  0x43,0xCF,0x4A,0xC5,0x08 ;Opcode: 0x43 - LD   (nn),dd  
	.DB  0x0A,0xFF,0x4A,0x23,0x2A ;Opcode: 0x0A - LD   A   ,(BC)
	.DB  0x1A,0xFF,0x4A,0x23,0x2B ;Opcode: 0x1A - LD   A   ,(DE)
	.DB  0x3A,0xFF,0x4A,0x23,0x05 ;Opcode: 0x3A - LD   A   ,(nn)
	.DB  0x2A,0xFF,0x4A,0x18,0x05 ;Opcode: 0x2A - LD   HL  ,(nn)
	.DB  0xF9,0xFF,0x4A,0x2C,0x18 ;Opcode: 0xF9 - LD   SP  ,HL  
	.DB  0x01,0xCF,0x4A,0x08,0x04 ;Opcode: 0x01 - LD   dd  ,nn  
	.DB  0x4B,0xCF,0x4A,0xC8,0x05 ;Opcode: 0x4B - LD   dd  ,(nn)
	.DB  0x57,0xFF,0x4A,0xE3,0x2D ;Opcode: 0x57 - LD   A   ,I   
	.DB  0x5F,0xFF,0x4A,0xE3,0x2E ;Opcode: 0x5F - LD   A   ,R   
	.DB  0x47,0xFF,0x4A,0xED,0x23 ;Opcode: 0x47 - LD   I   ,A   
	.DB  0x4F,0xFF,0x4A,0xEE,0x23 ;Opcode: 0x4F - LD   R   ,A   
	.DB  0x06,0xC7,0x4A,0x06,0x02 ;Opcode: 0x06 - LD   r   ,n   
	.DB  0xA8,0xFF,0x4B,0xC1,0x01 ;Opcode: 0xA8 - LDD      ,    
	.DB  0xB8,0xFF,0x4C,0xC1,0x01 ;Opcode: 0xB8 - LDDR     ,    
	.DB  0xA0,0xFF,0x4D,0xC1,0x01 ;Opcode: 0xA0 - LDI      ,    
	.DB  0xB0,0xFF,0x4E,0xC1,0x01 ;Opcode: 0xB0 - LDIR     ,    
	.DB  0x44,0xFF,0x4F,0xC1,0x01 ;Opcode: 0x44 - NEG      ,    
	.DB  0x00,0xFF,0x50,0x01,0x01 ;Opcode: 0x00 - NOP      ,    
	.DB  0xB0,0xF8,0x51,0x07,0x01 ;Opcode: 0xB0 - OR   r2  ,    
	.DB  0xF6,0xFF,0x51,0x02,0x01 ;Opcode: 0xF6 - OR   n   ,    
	.DB  0xBB,0xFF,0x52,0xC1,0x01 ;Opcode: 0xBB - OTDR     ,    
	.DB  0xB3,0xFF,0x53,0xC1,0x01 ;Opcode: 0xB3 - OTIR     ,    
	.DB  0x41,0xC7,0x54,0xEF,0x06 ;Opcode: 0x41 - OUT  (C) ,r   
	.DB  0xD3,0xFF,0x54,0x03,0x23 ;Opcode: 0xD3 - OUT  (n) ,A   
	.DB  0xAB,0xFF,0x55,0xC1,0x01 ;Opcode: 0xAB - OUTD     ,    
	.DB  0xA3,0xFF,0x56,0xC1,0x01 ;Opcode: 0xA3 - OUTI     ,    
	.DB  0xC1,0xCF,0x57,0x09,0x01 ;Opcode: 0xC1 - POP  qq  ,    
	.DB  0xC5,0xCF,0x58,0x09,0x01 ;Opcode: 0xC5 - PUSH qq  ,    
	.DB  0x80,0xC0,0x59,0x8D,0x07 ;Opcode: 0x80 - RES  b   ,r2  
	.DB  0xC9,0xFF,0x20,0x01,0x01 ;Opcode: 0xC9 - RET      ,    
	.DB  0xC0,0xC7,0x20,0x0B,0x01 ;Opcode: 0xC0 - RET  cc  ,    
	.DB  0x4D,0xFF,0x21,0xC1,0x01 ;Opcode: 0x4D - RETI     ,    
	.DB  0x45,0xFF,0x22,0xC1,0x01 ;Opcode: 0x45 - RETN     ,    
	.DB  0x10,0xF8,0x5A,0x87,0x01 ;Opcode: 0x10 - RL   r2  ,    
	.DB  0x17,0xFF,0x5B,0x01,0x01 ;Opcode: 0x17 - RLA      ,    
	.DB  0x00,0xF8,0x5C,0x87,0x01 ;Opcode: 0x00 - RLC  r2  ,    
	.DB  0x07,0xFF,0x5D,0x01,0x01 ;Opcode: 0x07 - RLCA     ,    
	.DB  0x6F,0xFF,0x5E,0xC1,0x01 ;Opcode: 0x6F - RLD      ,    
	.DB  0x18,0xF8,0x5F,0x87,0x01 ;Opcode: 0x18 - RR   r2  ,    
	.DB  0x1F,0xFF,0x60,0x01,0x01 ;Opcode: 0x1F - RRA      ,    
	.DB  0x08,0xF8,0x61,0x87,0x01 ;Opcode: 0x08 - RRC  r2  ,    
	.DB  0x0F,0xFF,0x62,0x01,0x01 ;Opcode: 0x0F - RRCA     ,    
	.DB  0x67,0xFF,0x63,0xC1,0x01 ;Opcode: 0x67 - RRD      ,    
	.DB  0xC7,0xC7,0x1D,0x0C,0x01 ;Opcode: 0xC7 - RST  t   ,    
	.DB  0x98,0xF8,0x64,0x23,0x07 ;Opcode: 0x98 - SBC  A   ,r2  
	.DB  0xDE,0xFF,0x64,0x23,0x02 ;Opcode: 0xDE - SBC  A   ,n   
	.DB  0x42,0xCF,0x64,0xD8,0x08 ;Opcode: 0x42 - SBC  HL  ,dd  
	.DB  0x37,0xFF,0x65,0x01,0x01 ;Opcode: 0x37 - SCF      ,    
	.DB  0xC0,0xC0,0x66,0x8D,0x07 ;Opcode: 0xC0 - SET  b   ,r2  
	.DB  0x20,0xF8,0x67,0x87,0x01 ;Opcode: 0x20 - SLA  r2  ,    
	.DB  0x30,0xF8,0x68,0x87,0x01 ;Opcode: 0x30 - SLL  r2  ,    
	.DB  0x28,0xF8,0x69,0x87,0x01 ;Opcode: 0x28 - SRA  r2  ,    
	.DB  0x38,0xF8,0x6A,0x87,0x01 ;Opcode: 0x38 - SRL  r2  ,    
	.DB  0x90,0xF8,0x6B,0x07,0x01 ;Opcode: 0x90 - SUB  r2  ,    
	.DB  0xD6,0xFF,0x6B,0x02,0x01 ;Opcode: 0xD6 - SUB  n   ,    
	.DB  0xA8,0xF8,0x6C,0x07,0x01 ;Opcode: 0xA8 - XOR  r2  ,    
	.DB  0xEE,0xFF,0x6C,0x02,0x01 ;Opcode: 0xEE - XOR  n   ,    
	.DB  0x00,0x00,0x6D,0x01,0x01 ;Opcode: 0x00 - ????     ,    
	.DB  0x00,0x00,0x6D,0xC1,0x01 ;Opcode: 0x00 - ????     ,    
