Program sendsrec;

// simple hack: connect to the terminalserverport where the 
// download port of the MAI2000 is connected. Wait for a 
// filename from the mai 2000 debugger and send this file

// the debugger sends all keys typed after LOAD to the 
// download port. I have configured the download port to a 
// port on a fourway that is connected to the terminalserver

// The debugger accepts s-record files generated by Alfred 
// Arnold's asl

// Armin Diehl December, 2011

// used on linux but should also run on other platforms
// supported by FreePascal

{$i-}

uses ssockets, sysutils;

Const
  TheHost : string = '192.168.254.20';
  ThePort = 5001;

var
  fileName,lastFilename,line : String;
  len : longint;
  c : char;
  t : text;

begin
  if paramcount > 0 then TheHost := paramstr(1);
  writeln ('Connecting to ',TheHost,':',ThePort);
  filename := ''; lastFilename := '';
  With TInetSocket.Create(TheHost,ThePort) do
    begin
      writeln('Connected');
      repeat
        len := Read(c,1);
        if len > 0 then
        begin
          if (c >= ' ') and (c < #127) then
          begin
            fileName := fileName + c;
            system.write(c);
          end else
          if (c = #13) or (c = #10) then
          begin
            writeln;
            if filename = '' then filename := lastFilename;
            if fileName <> '' then
            begin
              assign(t,fileName); reset(t);
              if ioresult <> 0 then
              begin
                assign(t,fileName+'.srec'); reset(t);
              end;
              if ioresult = 0 then
              begin
                repeat
                  readln(t,line); line := line + #13;
                  write(line[1],length(line));
                  system.write(line+#10);
                until eof(t);
                close(t);
              end else
                writeln('"',filename,'" not found');
              lastFileName := filename;
              filename := '';
            end else writeln('no file name given');
          end else system.write(' ?0x',IntToHex(byte(c),2),'? ');
        end;
      until len=0;
      writeln('Connection terminated');
      Free;
    end;
end.
