#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#define ObjExtension ".o"

static char *getobj(const char *pSrc)
{
  static char buffer[255];
  int l = strlen(pSrc);
  char *pSearch;
  
  if (l < sizeof(buffer) - 5)
    l = sizeof(buffer) - 5;
  memcpy(buffer, pSrc, l); buffer[l] = '\0';

  pSearch = strrchr(buffer, '.');
  if (pSearch)
    strcpy(pSearch, ObjExtension);

  return buffer;
}

int main(int argc, char **argv)
{
  int z, l;
  FILE *pFile, *pDestFile;
  char line[512], *pCmd, *pName, *pDestFileName = NULL;
  char used[1024];

  if (argc < 2)
  {
    fprintf(stderr, "usage: %s [args] <file(s)>\n", *argv);
    exit(1);
  }

  memset(used, 0, sizeof(used));

  for (z = 1; z < argc; z++)
    if ((!used[z]) && (*argv[z] == '-'))
    {
      used[z] = 1;
      if (!strcmp(argv[z] + 1, "o"))
      {
        if (z >= argc - 1)
          pDestFileName = NULL;
        else
        {
          pDestFileName = argv[z + 1];
          used[z + 1] = 1;
        }
      }
    }

  if (pDestFileName)
  {
    pDestFile = fopen(pDestFileName, "w");
    if (!pDestFile)
    {
      perror(pDestFileName);
      exit(errno);
    }
  }
  else
    pDestFile = stdout;

  fprintf(pDestFile, "# auto-generated by %s - do not edit\n\n", *argv);

  for (z = 1; z < argc; z++)
  {
    if (used[z])
      continue;

    fprintf(pDestFile, "%s:", getobj(argv[z]));

    pFile = fopen(argv[z], "r");
    if (!pFile)
    {
      perror(argv[z]);
      exit(errno);
    }

    while (!feof(pFile))
    {
      fgets(line, sizeof(line), pFile);
      l = strlen(line);
      if ((l > 0) && (line[l - 1] == '\n'))
        line[l - 1] = '\0';

      if (*line != '#')
        continue;
      pCmd = strtok(line + 1, " \t");
      if (strcmp(pCmd, "include"))
        continue;

      pName = strtok(NULL, " \t");
      if (!pName)
        continue;
      l = strlen(pName);
      if ((*pName != '"') || (pName[l - 1] != '"'))
        continue;

      fprintf(pDestFile, " %*.*s", l - 2, l - 2, pName + 1);
    }

    fclose(pFile);

    fprintf(pDestFile, "\n\n");
  }

  if (pDestFileName)
  {
    fprintf(pDestFile, "%s:", pDestFileName);
    for (z = 1; z < argc; z++)
      if (!used[z])
        fprintf(pDestFile, " %s", argv[z]);
    fprintf(pDestFile, "\n");
  }

  return 0;
}
