; **********************************************************************
; **  Device Driver                                   by Armin Diehl  **
; **  Hardware:  CPM Console
; **  Interface: Serial SIO/2                                         **
; **********************************************************************



            .CODE

CPM_CONInitialize:
	RET


BCONST  EQU     2
BCONIN  EQU     3
BCONOUT EQU     4

; call cpm  bios function, function no in A (beginning with 0 for cold boot)
BIOSCALL:
	PUSH    BC
	LD      B,0
        LD      C,A
        LD      HL,(1)  ; 0000: JMP wboot (1)
        DEC     HL
        DEC     HL
        DEC     HL      ; cold boot=function 0
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        POP     BC
        JP      (HL)

CONST:
	PUSH	BC
	PUSH	HL
	LD	A,BCONST
	CALL	BIOSCALL


; CPM bios input character
;   On entry: No parameters required
;   On exit:  A = Character input from the device
;             NZ flagged if character input
;             BC DE HL IX IY I AF' BC' DE' HL' preserved
CPM_CONInputChar:
	PUSH	BC
	PUSH	HL
	LD	A,BCONST	; Status A=0:no char available, 0xFF=char is available
	CALL	BIOSCALL
	OR	A
	JP	Z, NoCharAvail
	LD	A,BCONIN
	CALL	BIOSCALL	; char in A
	OR	0xFF

NoCharAvail:
CPM_CONInputChar_End:
	POP	HL
	POP	BC
	RET            


; CPM bios output character
;   On entry: A = Character to be output to the device
;   On exit:  If character output successful (eg. device was ready)
;               NZ flagged and A != 0
;             If character output failed (eg. device busy)
;               Z flagged and A = Character to output
;             BC DE HL IX IY I AF' BC' DE' HL' preserved
CPM_CONOutputChar:
        PUSH    BC
        PUSH    DE
        PUSH    HL
        LD      A,BCONOUT
        CALL    BIOSCALL
        POP     HL
        POP     DE
        POP     BC
	OR	0xFF
        RET


; **********************************************************************
; **  End of driver: CPM console                                      **
; **********************************************************************









