uses sysutils,
     classes,
     tdefs;

(*$I-*)

const fn='S????';
      outPrefix = 'out/';

type

  barray = array [0..$FFFFFF] of byte;

var sr : TSearchRec;
  err : longint;
  listMode : boolean = false;
  fileList : TStringList;
  i : integer;

procedure processFile(fn : string);
var p : ^barray;
    f : file;
    s,fname,fdir : string;
    fm:integer;
    fsize:longint;
begin
  fm := filemode; filemode:=0;  //readonly
  assign(f,fn); reset(f,1); fsize := fileSize(f); 
  getmem(p,fsize); blockread(f,p^,fsize); close(f);  
  filemode := fm;
  if ioresult <> 0 then
   begin
     writeln('unable to read ',fn); exit;
   end;
  if listMode then
    with psavePrefix(p)^ do
      begin
        write('L01: ',IntToHex(unknownL01,8),
              ' L02: ',IntToHex(unknownL02,8),
              ' L03: ',IntToHex(unknownL03,8),
              ' L04: ',IntToHex(unknownL04,8),
              ' L11: ',IntToHex(unknownL11,8));
      end;
  s := psavePrefix(p)^.xtype;
  write(' "',s,'" '); 
  if (s = '**FILE**') then
  begin
    //fname := ExtractFileName(strpas(@psavePrefix(p)^.fileName));
    fname := strpas(@psavePrefix(p)^.fileName);
    fdir := outPrefix+ExtractFileDir(fname);
    writeln('"',fname,'"');
    if listMode then   
      exit;
    forceDirectories(fdir);
    assign(f,outPrefix+fname); rewrite(f,1);
    if ioresult <> 0 then
     begin
       writeln('unable to create ',outPrefix+fname); exit;
     end;    
    blockWrite(f,p^[sizeof(tsavePrefix)],fsize-sizeof(tsavePrefix));
    close(f);
    if ioresult <> 0 then
     begin
       writeln('unable to write ',outPrefix+fname); exit;
     end;    
  end else writeln;
  freeMem(p,fsize);  
end;

var dir,fname : string;

begin
  if sizeof(tTapeHeader) <> 512 then
    begin
      writeln ('sizeof TTapeHeader is ',sizeof(TTapeHeader));
      halt;
    end;
  if sizeof(tsavePrefix) <> 512 then
    begin
      writeln ('sizeof tsavePrefix is ',sizeof(tsavePrefix));
      halt;
    end;
  dir :=paramStr(1);
  if dir = '-l' then
    begin
      listMode := true;
      dir := paramStr(2);
    end;
  if dir <> '' then
    dir := IncludeTrailingBackslash(dir);
  writeln ('src: ',dir+fn);
  fileList := TStringList.create;
  
  if findFirst(dir+fn,faAnyFile,sr) = 0 then
  begin
    repeat
      //write (sr.name,' ');
      fileList.add(dir+sr.name);
      err := findNext(sr);
    until err <> 0;
    findClose(sr);
    fileList.sort;
    for i := 0 to fileList.count-1 do
      begin
        fname := fileList[i];
        write(extractFileName(fname),': ');
        processFile(fname);
      end; 
  end;
end.
