{$I+}
{$mode objfpc}

uses sysutils;

type
  tSaveSetHeader = packed record
    null1   : char;
    p       : char;  // P
    SetName : array [0..28] of char;
    unknown01: longint;
    unknown02: longint;
    unknown03: longint;
    unknown04: longint;
    unknown05: longint;
    unknown06: longint;
    unknown07: longint;
    unknown08: longint;
    unknown09: longint;
    unknown10: longint;
    Version  : array [0..9] of char;  // MTP C0301#0
    c : char;
  end;
  pSaveSetHeader = ^tSaveSetHeader;

  tSaveSetFile = packed record
    siz      : word;
    unknownw1: word;
    flags    : longint;
    unknown01: longint;
    unknown02: longint;
    unknown03: longint;
    unknown04: longint;
    unknown05: longint;
    unknown06: longint;
    unknown07: longint;
    unknown08: longint;
    unknown09: longint;
    unknown10: longint;
    unknown11: word;
    filename : array [0..255] of char;
  end;
  pSaveSetFile = ^tSaveSetFile;

function fix2str(p:pchar;len:integer):string;
var i : integer;
begin
  result := '';
  for i := 1 to len do begin result := result + p^; inc(p); end;
end;

procedure printhex(p:pchar; len:integer);
var s : string;
    i : integer;
begin
  s:='';
  for i := 1 to len do
    begin
      if (p^>' ') and (p^<#$7f) then s := s + p^ else s := s + '.';
      write(IntToHex(byte(p^),1),' ');
      inc(p);
    end;
  writeln;
end;

procedure printHeader(var h : tSaveSetHeader);
begin
  with h do
    begin
      writeln('saveset: "',SetName,'"');
      writeln('version: "',fix2str(version,10),'"');
    end;
end;



function printFile(var f : tSaveSetFile) : integer;  // returns len
var len,slen : integer;
begin
  //len := swap(f.siz) - 78;
  slen := strlen(f.filename); //len - sizeof(f) + sizeof(f.filename);
  len := sizeof(f)-sizeof(f.filename)+slen+1;
  result := len;
  writeln(len,' ',slen);
  with f do
    begin
      writeln('siz      : ',inttohex(siz,4));
      writeln('unknownw1: ',inttohex(unknownw1,4));
      writeln('flags    : ',inttohex(flags,8));
      writeln('unknown01: ',inttohex(unknown01,8));
      writeln('unknown02: ',inttohex(unknown02,8));
      writeln('unknown03: ',inttohex(unknown03,8));
      writeln('unknown04: ',inttohex(unknown04,8));
      writeln('unknown05: ',inttohex(unknown05,8));
      writeln('unknown06: ',inttohex(unknown06,8));
      writeln('unknown07: ',inttohex(unknown07,8));
      writeln('unknown08: ',inttohex(unknown08,8));
      writeln('unknown09: ',inttohex(unknown09,8));
      writeln('unknown10: ',inttohex(unknown10,8));
      writeln('unknown11: ',inttohex(unknown11,4));
      writeln('filename : "',fix2str(@filename[0],slen),'"');
    end;
end;

var f : file;
    buf,p:pchar;
    bufSize,recLen : longint;
begin
  filemode := 2;
  assign(f,paramstr(1)); reset(f,1);
  bufSize := filesize(f);
  writeln(bufSize);
  getmem(buf,bufSize); blockread(f,buf^,bufSize);
  close(f);
  writeln('2');
  p := buf;
  p := p +512; // skip file header
  printHeader(pSaveSetHeader(p)^);
  inc(p,sizeof(tSaveSetHeader));
  printhex(p,16);
  reclen := printFile(pSaveSetFile(p)^);
  inc(p,reclen);
  reclen := printFile(pSaveSetFile(p)^);
  writeln;
end.
