unit t_listContents;

{$mode objfpc}{$H+}

interface

uses
  SysUtils, tdefs, tio;

procedure listTapeContents (t : tTapeIO);

implementation

procedure showHeader(var h : tTapeHeader);
var
  tapeFormat,OriginatingSystem : string;
begin

  writeln('TAPE LABEL');
  writeln('----------');
  if h.volBlank <> 'VOL ' then
    raise TTapeFormatErrorException.Create('Tape header does not start with "VOL "');
  // there are: Boot,Intersystem,Dump,Backup
  if h.volType = '30' then
    tapeFormat := 'Backup' else
  if h.volType = '33' then
    tapeFormat := 'Boot' else
    tapeFormat := 'unknown '+h.VolType;

  if h.unknown01 = '01' then
    OriginatingSystem := 'BOSS/IX'
  else
    OriginatingSystem := 'unknown';

  writeLn('Tape set name:      ',h.tapeSetName);
  writeln('Tape Id:            ',h.tapeId);
  writeln('Tape serial number: ');
  writeln('Tape volume number: ');
  writeln('Tape Format:        ',tapeFormat);
  writeln('Originating system: ',OriginatingSystem);  //Originating system: BOSS/IX
  with h.createDate do
  writeln('Date first labeled: ',month,'/',day,'/',year);  // 11/01/11
  with h.writeDate do
  writeln('Time last labeled:  ',month,'/',day,'/',year);  // 11/01/11
  writeln('Date last labeled:  ',h.writeTime.hour,':',h.writeTime.Minute); // Time last labeled:  08:42 am
end;

procedure listSaveset(dataPtr:pchar);
begin
end;

procedure listTapeContents (t : tTapeIO);
var
  f : TTapeFile;
  i,saveSets : integer;
begin
  f := nil;
  i := 0; saveSets := 0;
  try
    repeat
      f := t.readNextFile;
      if i = 0 then
        showHeader(pTapeHeader(f.dataPtr)^)
      else
        if ts_getFileType(f.dataPtr) = ft_saveset then
          begin
            listSaveset(f.dataPtr);
            inc(saveSets);
          end;
      f.Free; f := nil;
      inc(i);
    until false;
  finally
    if assigned(f) then f.Free;
  end;
  if saveSets = 0 then
    writeln ('No savesets on tape');
end;

end.

