program tlist;

{$mode objfpc}{$H+}

uses
  heaptrc,
  {$IFDEF UNIX}{$IFDEF UseCThreads}
  cthreads,
  {$ENDIF}{$ENDIF}
  Classes, sysutils,tdefs, tio,
  CustApp, t_listContents
  { you can add units after this };

type

  { TMyApplication }

  TMyApplication = class(TCustomApplication)
  protected
    procedure DoRun; override;
  public
    constructor Create(TheOwner: TComponent); override;
    destructor Destroy; override;
    procedure WriteHelp; virtual;
    procedure ShowException(E: Exception); override;
  end;

{ TMyApplication }

procedure TMyApplication.DoRun;
var
  ErrorMsg: String;
  t : TTapeIO;
begin
  checkStructs;
  // quick check parameters
  ErrorMsg:=CheckOptions('hd:',['help','dev:']);
  if ErrorMsg<>'' then begin
    ShowException(Exception.Create(ErrorMsg));
    Terminate;
    Exit;
  end;

  // parse parameters
  if HasOption('h','help') then begin
    WriteHelp; Terminate; Exit;
  end;

  if not HasOption('d','dev') then
    begin
      writeln('no device specified');
      writeHelp; Terminate; exit;
    end;
  { add your program here }
  t := TTapeIO.create(GetOptionValue('d','dev'));
  try
    listTapeContents (t);
  finally
    t.Free;
  end;

  // stop program loop
  Terminate;
end;

constructor TMyApplication.Create(TheOwner: TComponent);
begin
  inherited Create(TheOwner);
  StopOnException:=True;
end;

destructor TMyApplication.Destroy;
begin
  inherited Destroy;
end;

procedure TMyApplication.WriteHelp;
begin
  { add your help code here }
  writeln('Usage: ',ExeName);
  writeln(' -h, --help        show usage');
  writeln(' -dDEV, --dev=DEV  tape device or directory with tape files');
end;


procedure TMyApplication.ShowException(E: Exception);
begin
  writeln(e.message);
end;

var
  Application: TMyApplication;

{$R *.res}

begin
  Application:=TMyApplication.Create(nil);
  Application.Title:='My Application';
  Application.Run;
  Application.Free;
end.
