/*
 * Convert .tap tape image files to single files as needed by the
 * MAI 2000 simulator (for files for tne MAI 3000 found at
 * ftp://ftp.informatik.uni-stuttgart.de/pub/cm/mai/
 * Armin Diehl <ad@ardiehl.de> April 25, 2015
 * 
 * **************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <errno.h>

FILE *fin,*fout;


uint32_t readLength(void) {
	int i;
	uint32_t len;
	// TODO: change for other endian
    //0x0200 => 512 Bytes
	i = fread(&len,1,4,fin);
	
	if (i != 4) {
		printf("error reading data length, got %d, expected 4 bytes\n",i);
		fclose(fin);
		exit(1);
	}
	return len & 0xfffffff;  // there are bits in the upper nibble that i'm not aware of
}	

int main (int argc, char * argv[]) {

  int fileNo = 0;
  int dataLen,dataIO;
  char fileName[20];
  char * dataP;
  
  setbuf(stdout, NULL);

  if (argc != 2) {
	  printf("usage: %s TapFileName\n",argv[0]);
	  return 1;
   }
   if ( !(fin = fopen(argv[1],"rb"))) {
		printf("failed to open %s\n",argv[1]);
		return 1;
   }
  dataLen = readLength();
  while (dataLen != 0) {
	  fileNo++;
	  sprintf(fileName,"F%05d",fileNo);
	  if ( (fout = fopen(fileName,"wb")) == NULL) {
		  printf("filed to create %s\n",fileName);
		  fclose(fin);
		  exit(1);
	  }
      while (dataLen != 0) {
		  if (! (dataP = malloc(dataLen))) {
			  printf("unable to allocate %d (0x%8x) bytes\n",dataLen,dataLen);
			  fclose(fin);
			  exit(1);
		  }
		  dataIO = fread(dataP,1,dataLen,fin);
		  if (dataIO != dataLen) {
			  printf("read src: expected %d but fread returned %d bytes, errno=%d\n",dataLen,dataIO,errno);
			  fclose(fin);
			  exit(1);
		  }
		  
		  dataIO = fwrite(dataP,1,dataLen,fout);
		  if (dataIO != dataLen) {
			  printf("write dst: expected %d but fwrite returned %d bytes, errno=%d\n",dataLen,dataIO,errno);
			  fclose(fin);
			  exit(1);
		  }
		  free(dataP);
		  dataLen = readLength();  // this is the same again, it was written before and after each block
		  dataLen = readLength();  // this is the one for the next block or 0 for EOF
	  }
	  fclose(fout);
	  dataLen = readLength();
	  putchar('.');
  }
  fclose(fin);
  printf("\nwrote %d files.\n",fileNo);
  return 0;	
}
