/*	ctypes.h	Character Classification Macros */
/* some programs written for UNIX depend on these values! */

#define	_U	0001		/* is uppercase alpha */
#define	_L	0002		/* is lowercase alpha */
#define	_N	0004		/* is numeric */
#define	_S	0010		/* is a space */
#define	_P	0020		/* is a punctuation mark */
#define	_C	0040		/* is a control char */
#define	_O	0100		/* is an octal digit */
#define	_X	0200		/* is a hex digit */

extern char	_ctype[257];

#define	isalpha(c)	(((_ctype+1)[c])&(_U|_L))
#define	isupper(c)	(((_ctype+1)[c])&_U)
#define	islower(c)	(((_ctype+1)[c])&_L)
#define	isdigit(c)	(((_ctype+1)[c])&_N)
#define	isxdigit(c)	(((_ctype+1)[c])&_X)
#define ishex(c)	(((_ctype+1)[c])&_X)
#define isoctal(c)	(((_ctype+1)[c])&_O)
#define	isalnum(c)	(((_ctype+1)[c])&(_U|_L|_N))
#define	isspace(c)	(((_ctype+1)[c])&_S)
#define iswhite(c)	(((_ctype+1)[c])&_S)
#define	ispunct(c)	(((_ctype+1)[c])&_P)
#define	isprint(c)	(!(((_ctype+1)[c])&_C))
#define	isgraph(c)	(!(((_ctype+1)[c])&(_C|_S)))
#define	iscntrl(c)	(((_ctype+1)[c])&_C)
#define	isascii(c)	(((c) >> 7) == 0)
#define	_toupper(c)	((c)-'a'+'A')
#define	_tolower(c)	((c)-'A'+'a')
#define	toascii(c)	((c)&0177)
