#ifndef WINDOW

#include <stdio.h>
#include <termcap.h>
#include <ttymodes.h>
#include <sgtty.h>

typedef int bool;

typedef struct _win_st {
	short	_cury, _curx;
	short	_maxy, _maxx;
	short	_begy, _begx;
	short	_flags;
	bool	_clear;
	bool	_leave;
	bool	_scroll;
	char	**_y;
	short	*_firstch;
	short	*_lastch;
} _WINDOW;

#define WINDOW _WINDOW

#define _SUBWIN		000001	/* this is a subwindow of something else */
#define _ENDLINE	000002
#define	_FULLWIN	000004
#define _SCROLLWIN	000010
#define _FLUSH		000020
#define _FULLLINE	000040	/* window occupies entire terminal lines */
#define _STANDOUT	000200
#define _INSL		000400	/* did insert line to window */
#define _DELL		001000	/* did delete line to window */

#define _NOCHANGE	(-1)

#define reg register
#define bool char

#define TRUE 1
#define FALSE 0
#define ERR (0)		/* should really be -1 */
#define OK (1)		/* should really be 0 */

extern WINDOW	*curscr;	/* terminal image window */
extern WINDOW	*stdscr;	/* standard graphics window */
extern char	*Def_term;	/* Default term, if can't find one */
extern bool	My_term;	/* use Def_term even if can find terminal */
extern char	ttytype[];	/* pointer to tty name */
extern int	LINES;		/* set to override li# */
extern int	COLS;		/* set to override co# */
extern int	_tty_ch;	/* which line is the tty (unix number) */
extern bool	_endwin;	/* have we called endwin()? */
extern bool	_rawmode;	/* are we in raw mode, or something very much
					like it? */
extern bool	_echoit;	/* ECHO mode or not? */

extern bool AM, BS, CA, EO, HZ, IN, MI, MS, NC, OS, UL, XN;

typedef char *_ptr;

extern char PC;

extern _ptr AL, BC, BT, CD, CE, CL, CM, DC, DL, DM, DO, ED, EI, HO, IC, IM, IP,
	   LL, MA, ND, SE, SF, SO, SR, TA, TE, TI, UC, UE, UP, US, VB, VE, VS;

extern bool	NONL, GT, UPPERCASE, normtty, _pfast;
extern char	_tcbuf[];

/* because rogue (ab)uses _tty and _tty_ch, I must define a UNIX set */
typedef struct sgttyb SGTTY;

extern SGTTY _tty;
extern TTYMODE _ttym;	/* make UNOS version available */

extern char _newline[];	/* so we can pad NL if dN is set */

extern _putchar();

/* macros for stdscr */
#define addch(CH)	   	waddch(stdscr,CH)
#define	insch()			winsch(stdscr)
#define	insertln()		winsertln(stdscr)
#define mvaddch(Y,X,CH)		mvwaddch(stdscr,Y,X,CH)
#define addstr(STR)		waddstr(stdscr,STR)
#define mvaddstr(Y,X,STR)	mvwaddstr(stdscr,Y,X,STR)
#define clear()			wclear(stdscr)
#define clrtobot()		wclrtobot(stdscr)
#define clrtoeol()		wclrtoeol(stdscr)
#define mvdelch(Y,X)		mvwdelch(stdscr,Y,X)
#define deleteln()		wdeleteln(stdscr)
#define mvdeleteln(Y,X)		mvwdeleteln(stdscr,Y,X)
#define erase()			werase(stdscr)
#define mvinch(Y,X)		mvwinch(stdscr,Y,X)
#define mvinsch(Y,X,CH)		mvwinsch(stdscr,Y,X,CH)
#define mvinsertln(Y,X)		mvwinsertln(stdscr,Y,X)
#define move(Y,X)		wmove(stdscr,Y,X)
#define refresh()		wrefresh(stdscr)
#define standout()		wstandout(stdscr)
#define standend()		wstandend(stdscr)
#define getch()			wgetch(stdscr)
#define getstr(STR)		wgetstr(stdscr,STR)
#define inch()			winch(stdscr)
/* macros for pseudofunctions */
#define getyx(WIN,YV,XV)	((YV = (WIN)->_cury, XV = (WIN)->_curx))
#define winch(WIN)		((WIN)->_y[(WIN)->_cury][(WIN)->_curx])
#define clearok(WIN,BOOLF)	((WIN)->_clear = (BOOLF))
#define leaveok(WIN,BOOLF)	((WIN)->_leave = (BOOLF))
#define scrollok(WIN,BOOLF)	((WIN)->_scroll = (BOOLF))
#define flushok(WIN,BOOLF)	((BOOLF)?(WIN)->_flags |= _FLUSH:\
					 (WIN)->_flags &= ~_FLUSH)

WINDOW *newwin(), *subwin();
char *longname();

#endif WINDOW
