/*
 * defines for fcntl calls
 */

/* open modes */
#define O_RDONLY 000000		/* open only */
#define O_WRONLY 000001		/* open only */
#define O_RDWR	 000002		/* open only */
#define O_NDELAY 000004
#define O_APPEND 000010
#define O_CREAT	 000400		/* open only */
#define O_TRUNC	 001000		/* open only */
#define O_EXCL	 002000		/* open only */
#define O_CONTIG 004000		/* open only */

/* fcntl additional */
#define F_DUPFD	0		/* Duplicate fildes */
#define F_GETFD	1		/* Get FIOCLEX flag of FD */
#define F_SETFD 2		/* Set "	"	" */
#define F_GETFL 3		/* Get file flags (open modes) */
#define F_SETFL 4		/* Set file flags (open modes) */
#define F_CGETX 5		/* Get contig extent size in bytes (max) */
#define F_CSETX 6		/* Set contig extent size in bytes (max=min) */
#define F_CGETMIN 7		/* Get min acceptable contig extent size */
#define F_CSETMIN 8		/* Set min acceptable contig extent size */
#define F_CGROW 9		/* Force contig extent to be allocated now */
#define F_CGTSZ 10		/* Get max possible extent size in bytes */
#define F_CGTAL 11		/* Get total allocated size in bytes */

/* ioctl/spfun calls for FIOCLEX */
#define FIOCLEX		(('f'<<8)|1)
#define FIONCLEX	(('f'<<8)|2)
