
struct filehdr
 {
	unsigned short	f_magic;	/* magic number             */	
        unsigned short	f_vstamp;	/* version stamp            */
	unsigned short	f_nscns;	/* number of sections       */
	unsigned short	f_sizscnh;	/* size of section header   */
	long		f_timdat;	/* time & date stamp        */
	long		f_symptr;	/* file pointer to symtab   */
	long		f_sizsymt;	/* size of symtab           */
	long		f_nsyms;	/* number of symtab entries */
        long            f_sizstrt;      /* size of string table     */
        long            f_entry;        /* entry point              */
	unsigned short  f_entscn;       /* section number for entry 
	                                   point                    */
	unsigned short	f_opthdr;	/* size of optional hdr     */
	unsigned short	f_flags;	/* flags                    */
	unsigned short	f_fhdr; 	/* size of (this) file hdr  */
 };


#define	FILHDR	struct filehdr
#define	FILHSZ	sizeof(FILHDR)


/*
 *   Bits for f_flags:
 *
 *	F_RELFLG	relocation info stripped from file
 *	F_EXEC		file is executable  (i.e. no unresolved
 *				externel references)
 *	F_LNNO		line nunbers stripped from file
 *	F_LSYMS		local symbols stripped from file
 */

#define  F_RELFLG	0000001
#define  F_EXEC		0000002
#define  F_LNNO		0000004
#define  F_LSYMS	0000010

#define  F_M68K         0001000


/*
 *   Magic Numbers
 */

#define CRDSMAGIC   '.d'
