/*
	Header file for IPC facility
	Copyright (c) 1984 by Charles River Data Systems, Inc.

	MODIFIED BY	REASON
	06/01/84 wjr	created

*/

#include <sys/stypes.h>

/* message info structure for user */
typedef struct msg_info {
	UID	mi_uid;	/* senders uid */
	GID	mi_gid;	/* senders gid */
	PID	mi_pid;	/* senders pid */
	int	mi_type; /* message type */
} MSGINFO;

/* queue info structure for user */
typedef struct que_info {
	long	qi_key;		/* key for active queue, 0 for inactive */
	short	qi_seq;		/* sequence number for re_using queue */
	short	qi_nbytes;	/* no. of message bytes on queue */
	UID	qi_cuid;	/* creators uid */
	GID	qi_cgid;	/* creators gid */
	UID	qi_uid;		/* current owner uid */
	GID	qi_gid;		/* current owners gid */
	MODES	qi_mode;	/* access modes (rw rw rw)*/
	short	qi_qnum;	/* no. of messages in queue */
	short 	qi_qbytes;	/* no. of message bytes allowed in queue */
	PID	qi_lspid;	/* pid of last sender */
	PID	qi_lrpid;	/* pid of last receiver */
	long	qi_stime;	/* time of last send */
	long	qi_rtime;	/* time of last receive */
	long	qi_ctime;	/* time of creation */
} QUEINFO;

typedef long MQID; /* message queue identifier */


/* commands for ipcfun */
#define IPC_CSTAT	1
#define IPC_CSET	2
#define IPC_CRMQ	3
#define IPC_CSANY	4

/* flags for ipc{get!snd!rcv} */
#define IPC_FNOWAIT	0x10000
#define IPC_FNOERR	0x20000
#define IPC_FCREAT	0x40000
#define IPC_FEXCL	0x80000

/* permission bits for flag word */
#define IPC_OREAD	0x4
#define IPC_OWRITE	0x2
#define IPC_GREAD	0x40
#define IPC_GWRITE	0x20
#define IPC_DREAD	0x400
#define IPC_DWRITE	0x200



/* private key */
#define IPC_PRIVATE	-1

