/*  The following is a list of the "Limitations of Magnitude" imposed by UNOS.
    These names conform to the proposed /usr/group standard.  */

#define ARG_MAX	  LONG_MAX	/*  Total size of arguments to exec. */
#define CHAR_BIT  8		/*  Bits per char (byte).  */
#define CHAR_MAX  127		/*  Max value of a char (signed).  */
#define CHAR_MIN  -128		/*  Min value of a char (signed).  */
#define CLK_TCK	  50		/*  Ticks/second in CPU usage values.  */
#define DBL_DIG	  16		/*  Digits of precision in double.  */
#define DBL_MAX	  1.797693134862315E+308  /*  Largest value of a double.*/
/* actually it is 1.7976931348623159077293051907890247336... but the compiler
 * cannot handle that many digits ^ it must be truncated here.
 */
#define DBL_MIN	  4.940656458412466E-324  /*  Smallest positive double.  */
/*		  4.940656458412465441765687928682213723...e-324  but we must
 *	round up so compiler can generate the number.  This is an IEEE
 *	denormalized number, note.  If you prefer normalized numbers, use
#define DBL_MIN	  2.2250738585072014e-308
 */
#define FCHR_MAX  LONG_MAX	/*  Size of largest possible file.  */
#define FLT_DIG	  7		/*  Digits of precision in float.  */
#define FLT_MAX	  3.402823E+38	/*  Largest value of a float.  */
#define FLT_MIN	  1.401298E-45	/*  Smallest positive float (DENORM).  */
/*
#define FLT_MIN	  1.175495E-38	/*  Normalized smallest float. */

#define HUGE_VAL  DBL_MAX	/*  Error value from math functions.  */
#define INT_MAX	  LONG_MAX	/*  Largest positive int.  */
#define INT_MIN	  LONG_MIN	/*  Most negative int.  */
#define CHILD_MAX (PROC_MAX-2)	/*  Max number of offspring per process.  */
#define LOCK_MAX  LONG_MAX	/*  Max file locks (limited by config file). */
#define LINK_MAX  127		/*  Max names for one file.  */
#define LONG_MAX  2147483647	/*  Largest positive long.  */
#define LONG_MIN  -2147483648	/*  Most negative long.  */
#define LONG_BIT  32		/*  Bits in long.  */
#define NAME_MAX  30		/*  Max characters in file name (dir entry). */
#define OPEN_MAX  100		/*  Max files that a process can have open.  */
#define PASS_MAX  9		/*  Max password length (counts '\0').  */
#define PATH_MAX  129		/*  Max file pathname length ('').  */
#define PID_MAX	  LONG_MAX	/*  Highest possible process id.  */
#define PIPE_BUF  4096		/*  Max atomic write to a pipe.  */
#define PIPE_MAX  LONG_MAX	/*  Largest possible write to a pipe.  */
#define PROC_MAX  256		/*  Max processes (limited by config file).  */
#define SHRT_MAX  32767		/*  Largest positive short.  */
#define SHRT_MIN  -32768	/*  Most negative short.  */
#define STD_BLK	  512		/*  "Standard" I/O block size.  */
#define SYS_NMLN  9		/*  Size of each string set by uname().  */
#define SYS_OPEN  LONG_MAX	/*  Max files whole system can have open.
				    Limited by config file.  */
#define UID_MAX	  SHORT_MAX	/*  Max value for a user or group id.  */
#define USI_MAX	  4294967295	/*  Largest unsigned int.  */
#define WORD_BIT  32		/*  Bits per int.  */
