/*  Declarations for mathematical subroutines.  */
extern double fabs (), floor (), ceil (), modf (), frexp (), ldexp ();
extern double hypot ();
extern double sin (), cos (), tan (), asin (), acos (), atan (), atan2 ();
extern double sinh (), cosh (), tanh ();
extern double sqrt (), pow (), exp (), ln (), log (), log10 ();
extern double j0 (), j1 (), jn (), y0 (), y1 (), yn ();
extern double poly (), even_rational (), odd_rational ();
extern double gamma();
int signgam;
extern double erf(), erfc();
extern int matherr();

extern int errno;

#define EDOM 33
#define ERANGE 34

extern int matherr();

struct exception
 {
  int type;
  char *name;
  double arg1, arg2, retval;
 };

#define   DOMAIN     1
#define   SING       2
#define   OVERFLOW   3
#define   UNDERFLOW  4
#define   TLOSS      5
#define   PLOSS      6

#define   HUGE       1.79769313486231570e307	/* return by math lib on err*/

/* some useful constants */
#define M_E		2.7182818284590452354	/* value of e */
#define M_LOG2E		1.4426950408889634074	/* value of log2(e) */
#define M_LOG10E	0.43429448190325182765	/* value of log10(e) */
#define M_LN2		0.69314718055994530942	/* value of ln(2) */
#define M_LN10		2.30258509299404568402	/* value of ln(10) */
#define M_PI		3.14159265358979323846	/* guess */
#define M_PI_2		1.57079632679489661923	/* pi / 2 */
#define M_PI_4		0.78539816339744830962	/* pi / 4 */
#define M_1_PI		0.31830988618379067154	/* 1 / pi */
#define M_2_PI		0.63661977236758134308	/* 2 / pi */
#define M_2_SQRTPI	1.12837916709551257390	/* 2 / sqrt(pi) */
#define M_SQRT2		1.41421356237309504880	/* sqrt(2) */
#define M_SQRT1_2	0.70710678118654752440	/* 1 / sqrt(2) */

#define MAXFLOAT	3.402823E+38	/*  Largest value of a float.  */
