/*  UNIX-compatible structure and flags for I/O control calls.
    Created as part of the UNIX library in December 1981 by R F Mabee.
    Copyright (c) 1981 by Charles River Data Systems, Inc.  */

struct sgttyb {
	char sg_ispeed;
	char sg_ospeed;
	char sg_erase;
	char sg_kill;
	int sg_flags;
};

struct tchars {			/* defined, not supported */
	char	t_intrc,
		t_quitc,
		t_startc,
		t_stopc,
		t_eofc,
		t_brkc;
};

/*  Values supported for sgttyb.sg_flags.  */
#define TBDELAY	06000
#define XTABS	06000
#define RAW	00040
#define CRMOD	00020
#define ECHO	00010
#define CBREAK	00002
#define EVENP	00200
#define ODDP	00100

/*  Values supported for code argument to ioctl.  */
/*
 *	ioctl arguments
 */
#define FIOCLEX		(('f'<<8)|1)
#define FIONCLEX	(('f'<<8)|2)
#define	TIOCHPCL	(('t'<<8)|2)
#define	TIOCGETP	(('t'<<8)|8)
#define	TIOCSETP	(('t'<<8)|9)
#define TIOCSETN	(('t'<<8)|10)
#define TIOCGETC	(('t'<<8)|11)
#define TIOCSETC	(('t'<<8)|12)
#define	TIOCEXCL	(('t'<<8)|13)
#define	TIOCNXCL	(('t'<<8)|14)
#define TIOCFLUSH	(('t'<<8)|15)

/*  Values of ispeed and ospeed - but not supported.  */
#define	B0	0	/* hang up dataphone */
#define B50	1
#define B75	2
#define B110	3
#define B134	4
#define B150	5
#define	B200	6
#define	B300	7
#define	B600	8
#define	B1200	9
#define	B1800	10
#define	B2400	11
#define	B4800	12
#define	B9600	13
#define	EXTA	14
#define	EXTB	15
/* the following have no corresponding values on UNIX but are defined
   anyway */
#define B_AUTO	15
#define B19200	14
#define B38400	15
#define SPEED_J_TO_U(S) (S > SSBR38400 ? SSBR38400 :S)
#define SPEED_U_TO_J(S) (S)