/*  Definitions of signal numbers for UNOS.  */

#define NSIG	32	/*	32 signals handled by UNOS */
#define SIGHUP	1	/*	Modem hanging up  */
#define SIGINT	2	/*	^C  */
#define SIGQUIT	3	/*  *	^Y  */
#define SIGILL	4	/*  *N	Illegal opcode, trapv, check, zero divide  */
#define SIGTRAP	5	/*  *N	Trace trap, trap $1 (breakpoint)  */
#define SIGIOT	6	/*  *	IOT instruction - not sent by UNOS  */
#define SIGEMT	7	/*  *	Trap $3-15  */
#define SIGFPE	8	/*  *	Floating-point error - not sent by UNOS  */
#define SIGKILL	9	/*	Uncatchable kill - kill command  */
#define SIGBUS	10	/*  *	Bus error, odd address  */
#define SIGSEGV	11	/*  *	MMU exception  */
#define SIGSYS	12	/*  *	Bad system call - not sent by UNOS  */
#define SIGPIPE	13	/*	Write on pipe with no readers  */
#define SIGALRM	14	/*	Timeout after alrm call  */
#define SIGTERM	15	/*	Software kill - not sent by UNOS  */
/*			    *	Default handler causes suspend or core dump  */
/*			     N	Not reset to default when caught  */
#define SIGUSR1 16	/*	User defined signal 1 */
#define SIGUSR2 17	/*	User defined signal 2 */
/*#define SIGCLD	18	/*	death of a child */
/*#define SIGPWR  19	/*	power fail */

/*  Special values for function argument to signal.  */
#define SIG_DFL	((int (*)())0)	/*  Default, kill or suspend or core dump  */
#define SIG_IGN ((int (*)())1)	/*  Ignore, no action  */
extern int (*signal()) ();

/*  Signal sent by abort().  /usr/group requires this map one of the above.  */
#define SIGABRT SIGIOT
