#ifndef _NFILE
#define _NFILE	80

#define BUFSIZ	512
#define _SBFSIZ 8

typedef struct {
	unsigned char	*_ptr;
	int	_cnt;
	unsigned char	*_base;
	short	_flag;		/* changed from char for UCB IOSTRG*/
	char	_file,
		_mod;
	long	_pos;		/* NOT CURRENTLY USED */
	char	_readvalid;	/* is fpos a READ pointer? (after buffer) */
	char	_padding;	/* not used */
	short	_bufsize;   /* how large buffer really is, for short read */
} FILE;

/*
 * _IOLBF means a file is a terminal; this means, in particular,
 * that output will be buffered line by line
 */
#define _IOREAD		00001
#define _IOWRT		00002
#define _IONBF		00004
#define _IOMYBUF	00010
#define _IOEOF		00020
#define _IOERR		00040
#define _IOLBF		00100
#define _IORW		00200
#define _IOSTRG		00400		/* UCB addition */
#define _IORAISE	01000		/* UNOS addition */
#define _IOLBF		02000		/* Line Buffered */
#define _IOFBF		00000		/* defaultly buffered */

#define NULL		0
#define EOF		(-1)

#define stdin		(&_iob[0])
#define stdout		(&_iob[1])
#define stderr		(&_iob[2])

#ifndef lint
#define void int
#define getc(p)		(--(p)->_cnt >= 0 ? (int) *((p)->_ptr)++ : _filbuf(p))
/* 13Nov84: dont mark modified till actually modified */
#define putc(x, p)	(--(p)->_cnt >= 0 ? \
			( ((p)->_mod=1),(int) (*(p)->_ptr++ = (x))) : \
			_flsbuf((x), (p)))
#define getchar()	getc(stdin)
#define putchar(x)	putc((x), stdout)
#define clearerr(p)	((p)->_flag &= ~(_IOERR | _IOEOF))
#define feof(p)		((p)->_flag & _IOEOF)
#define ferror(p)	((p)->_flag & _IOERR)
#define fileno(p)	(p)->_file
#define flush()		fflush(stdout)
#define _bufend(p)	(_bufendtab[ fileno(p) ])
#define _bufsiz(p)	(_bufend(p) - p->_base)
#endif
extern char *_bufendtab[];

extern FILE	_iob[_NFILE];
extern FILE	*fopen(), *fdopen(), *freopen(), *popen(), *tmpfile();
extern long	ftell();
extern void	rewind(), setbuf();
extern char	*ctermid(),*cuserid(), *fgets(),*gets(), *tempnam(),*tmpnam();

extern FILE	*fileopen(), *filereopen(), *fileluopen();

#define L_ctermid	9
#define L_cuserid	9
#define P_tmpdir	"/usr/tmp/"
#define L_tmpnam	(sizeof(P_tmpdir) + 15)

#endif _NFILE
#include <unos.h>
#include <standard.h>
