/*
	Define 68881 floating point coprocessor registers and state frames 

	Copyright (c) 1985 by Charles River Data Systems, Inc.

	MODIFIED BY	REASON

	10/25/85  die	Created to define these structures
	01/27/86  die   Made work with Whitesmiths



/* define some 68881 data structures */

#define FP 1

typedef	struct	fpreg
{	unsigned int fp_exponent, 	/* define extended precision reg*/
		     fp_mantissa_hi,
		     fp_mantissa_lo;
} FPREG;		

/* define version and size information for state */

typedef struct  fps
{	unsigned char	version,  /* 68881 version number */
			length;   /* number of additional bytes in frame */
	unsigned short	filler;	  /* reserved (always zero) */
} FPSTATE;


/* structure of null state frame */

typedef	struct fp_null_frame
{
	FPSTATE		fpstate; /* floating point version and frame type */
} FP_NULL_FRAME;


/* structure of idle state frame */

typedef	struct fp_idle_frame
{
	FPSTATE		fpstate;  /* floating point version and frame type */
	unsigned short	command;  /* command register */
	unsigned short	fill;	  /* reserved (always 0xFFFF) */
	FPREG		exop;	  /* exceptional operand */
	unsigned int	operand;  /* operand register */
	unsigned int	biu;	  /* status flags */

} FP_IDLE_FRAME;


/* structure of busy state frame */

typedef	struct fp_busy_frame
{
	FPSTATE		fpstate; /* floating point version and frame type */
	unsigned int	internal_state [45];  /* terra incognita */

} FP_BUSY_FRAME;


/* Define only bit in biu that Motorola (and UNOS) allows to be altered -
setting this bit causes an exception to become pending, clearing it clears
a pending exception - see section 4.3.2.1 of 68881 manual for more info */

#define FP_EXCP_PENDING		0x08000000
