/*  Definitions for the list of bad blocks as it appears on the disk.
    Created in January 1982 by R F Mabee.
    Copyright (c) 1982 by Charles River Data Systems, Inc.  */

# define max_bad_blocks 2000	/* 2 Gigabytes at 1 defect/mb */
# define bad_block_id '.bad'
# define bad_block_address (2 * 512)

typedef	struct bad_block_header
{	long id;		/*  Must contain '.bad'  */
	long version;		/*  This is version 1.  */
	long n_blocks;
	long defect_size;	/*  # of blocks, same for all.  */
				/*  Allows discarding entire track.  */
} bad_block_header;

typedef struct bad_block_struct
{
	bad_block_header header;
	long bad_block [max_bad_blocks + 1];	/*  Logical block number.  */
		/*  n_blocks entries, followed by at least one zero.  */
	/*  Round bb map up to block boundary */
	char rsmbz [SYSBSIZE-((sizeof(bad_block_header)+(4*(max_bad_blocks+1)))%SYSBSIZE)];
} bad_block_record;

