/*

	UNOS system configuration table

	Copyright (c) 1982 by Charles River Data Systems, Inc.

	9/13/83  larry	add cnf_{script!use_auto!spare}
	12/21/83 rfm	cnf_spare -> cnf_readonly_root for booting tape.
	01/11/84 john	Add cnf_nptys, cnf_spare again
	1/14/84	 tdh	add cnf_{dsmem!dsproc!dsproc_priority}
	1/29/84  tdh	add cnf_{ds_cache_sizes!ds_control_{cache!threshold}}
	02/27/84 rfm	Add cnf_iop_pollrate.
	03/16/84 rfm	Remove (change to filler) swap_pri_factor, M16 things.
	03/28/84 wjr	Add stuff for ipcs (cnf_ipc*)
	05/21/84 larry	Added:	cnf_contig, cnf_balloc, cnf_cmin, cnf_cmax
	08/08/84 rfm	Kill large DSNET object & recompile world.
	12/27/85 rfm	Add cnf_bb_size, # bytes in badblks pool.
*/

#ifndef STYPEDEF
#include <sys/stypes.h>
#endif

typedef struct
{
	long	cnf_magic;		/* magic number, should be '.cnf' */
	short	cnf_size;		/* number of bytes in table */
	devtype	cnf_rootdev;		/* root device, 0000 means ask */
	char	cnf_swapdev[32];	/* swap device, "" means ask */
	long	cnf_swapsize;		/* swap device size in blocks */
	short	cnf_nsysbuf;		/* number of system buffers */
	short	cnf_numproc;		/* number of process control blocks */
	unsigned char
		cnf_start_ceil_pri,	/* p_ceil_pri for start process */
		cnf_start_floor_pri,	/* p_floor_pri, ditto */
		cnf_swap_priority,	/* for swapper process */
		cnf_filler1;
	short	cnf_maxlu,		/* number of lus for whole system */
		cnf_nfopen,		/* number of open files, ditto */
		cnf_neventcalls,	/* number of ec calls, ditto */
		cnf_ndsegs;		/* number of (shared) data segments */
	short	cnf_filler2,		/* was swap_pri_factor */
		cnf_iawait_pri_factor,	/* tuning parameters for priorities */
		cnf_uawait_pri_factor,
		cnf_quantum_pri_factor;
	short	cnf_ttybufsize;		/* bytes of input buffer per tty */
	short	cnf_nfsys;		/* maximum mounted file systems */
	short	cnf_logsize;		/* size(bytes) of histogram log area */
	long	cnf_clock_rate;		/* clock chip input rate in Hertz */
	short	cnf_pause_at_boot;	/* should wait before mounting root? */
	long	cnf_filler3;		/* was floppy_step_time */
	short	cnf_nlocks;		/* max # of file locks (# locklists) */
	long	cnf_filler4;		/* was verify */
	char	cnf_erase_kill[2];	/* default erase and linekill chars */
	char	cnf_system_id[32];	/* name of computer system */
	short	cnf_nmulti;		/* blocks in multi block i/o buffer */
	short	cnf_errlog_size;	/* bytes of system error log buffer */
	devtype	cnf_recovery_rootdev;	/* recovery root, 0000 means ask */
	char	cnf_script[32];		/* name of script */
	char	cnf_use_auto;		/* != 0 if auto start ok */
	char	cnf_readonly_root;	/* mount ROOT read-only (i.e. tape) */
	char	cnf_nptys;		/* number of pseudoteletype devices */
	char	cnf_iop_pollrate;	/* poll after this many services */
	int	cnf_dsmem;		/* amount of memory to grab for
					   distributed systems structures */
	int	cnf_ipcnques;		/* number of ipc queues */
	int	cnf_ipctotmsg;		/* total number of message bytes */
	int	cnf_ipcmsgsiz;		/* max size of a single message */
	int	cnf_ipcqsize;		/* max message bytes on one queue */
	int	cnf_contig;		/* all created files are contiguous */
	int	cnf_balloc;		/* allocation chunk size */
	int	cnf_cmin;		/* minimum alloc size contig file */
	int	cnf_cmax;		/* maximum alloc size contig file */
	short	cnf_dfs_kill;		/* 1 = disable outgoing DFS */
	short	cnf_bb_size;		/* # bytes in badblks pool */
} conftable;
