/*
	distributed system include file

	Modifications:
	01/22/1986	tdh	eliminate unkind comments
	03/14/1986	tdh	shorten MAX_MBX_NAME for session b.d.

	Copyright (c) 1986 by Charles River Data Systems, Inc.
*/

#ifndef ds_H
#define ds_H

#include <unos.h>

#define MAX_NODE_NAME MAXFILENAME	/* max node name length		    */
#define MAX_MBX_NAME 16			/* max mailbox name length	    */

				/* LU extension states			    */
#define DS_ST_CLOSED	0
#define DS_ST_IDLE	1
#define DS_ST_MCSENT	2
#define DS_ST_CRSENT	3
#define DS_ST_CRRCVD	4
#define DS_ST_OPEN	5
#define DS_ST_CLOSING	6

				/* segment I/O function codes		    */
#define DS_MAKECONN		0
#define DS_CONNECT		1
#define DS_LISTEN		2
#define DS_CONNECT_CONFIRM	3
#define DS_DATA			4
#define DS_ABORT		5
#define DS_CLOSE		6
#define DS_GRACEFUL_CLOSE	7

/* the following three defines are for internal use only */
				/* standard args kind codes		    */
#define DS_GD_NODE	0		/* system node name		    */
#define DS_GD_SAP	1		/* module-specific addr bytestring  */
#define DS_GD_MORSAPS	2		/* recursion on GD_SAP		    */
/* the preceding three defines are for internal use only */

typedef struct {		/* interface data segment I/O structure	    */
	short structsize;		/* size of structure		    */
	int count;			/* bytes being written or available */
					/*  for read			    */
	int status;			/* status code for ids		    */
	unsigned funct : 8;		/* function code		    */
	unsigned priority : 4;		/* priority of ids		    */
	unsigned eoidu : 1;		/* end of interface data unit	    */
/* the following two elements are for internal use only; argssize must be 0 */
	int argssize;			/* total size of *args		    */
	char *args;			/* miscellany; alternating kind	    */
					/*  byte, size byte, and (size)	    */
					/*  bytes; kind byte is defined per */
					/*  interface (except node, mbx)    */
/* the preceding two elements are for internal use only; argssize must be 0 */
} ds_ids_io_tp;

/* ------------------------------------------------------------------------ */
int net_state();
/* int net_state(f)		/* return the state of the connection	    */
/* FILE *f;				/* open connection		    */
/* ------------------------------------------------------------------------ */
int net_read1();
/* int net_read1(f,		/* read an arrived interface data segment;  */
/*		 buf,		/* return number of bytes read or error	    */
/*		 nbyte)		/*					    */
/* FILE *f;				/* open connection		    */
/* void *buf;				/* buffer to read into		    */
/* int nbyte;				/* number of bytes to read	    */
/* ------------------------------------------------------------------------ */
int net_readseg();
/* int net_readseg(f,		/* read an arrived interface data segment;  */
/*		   buf,		/* possibly return error; update *idsio	    */
/*		   idsio)	/*					    */
/* FILE *f;				/* open connection		    */
/* void *buf;				/* buffer to read into		    */
/* ds_ids_io_tp *idsio;			/* I/O structure		    */
/* ------------------------------------------------------------------------ */
int net_write1();
/* int net_write1(f,		/* write an interface data segment; return  */
/*		  buf,		/* number of bytes written or error	    */
/*		  nbyte,	/*					    */
/*		  funct,	/*					    */
/*		  eoidu)	/*					    */
/* FILE *f;				/* open connection		    */
/* void *buf;				/* buffer to write from		    */
/* int nbyte;				/* number of bytes to write	    */
/* int funct;				/* segment I/O function code	    */
/* BOOL eoidu;				/* TRUE iff end of I.D.U.	    */
/* ------------------------------------------------------------------------ */
int net_writeseg();
/* int net_writeseg(f,		/* write an interface data segment;	    */
/*		    buf,	/* possibly return error		    */
/*		    idsio)	/*					    */
/* FILE *f;				/* open connection		    */
/* void *buf;				/* buffer to write from		    */
/* ds_ids_io_tp *idsio;			/* I/O structure		    */
/* ------------------------------------------------------------------------ */
int net_bufsize();
/* int net_bufsize(f)		/* return the expected xmit buffer size;    */
/*				/* possibly return error		    */
/* FILE *f;				/* open connection		    */
/* ------------------------------------------------------------------------ */
int net_numbufs();
/* int net_numbufs(f,		/* set and/or return the number of xmit	    */
/*		   nbufs)	/* buffers available for this connection;   */
/*				/* possibly return error		    */
/* FILE *f;				/* open connection		    */
/* int nbufs;				/* nonzero is desired number	    */
/* ------------------------------------------------------------------------ */
int net_capac();
/* int net_capac(f)		/* return the number of bytes that may be   */
/*				/* written w/o blocking, or error	    */
/* FILE *f;				/* open connection		    */
/* ------------------------------------------------------------------------ */
int net_getnode();
/* int net_getnode(f,		/* get the name of the node connected to;   */
/*		   buf,		/* return length of name (may be zero iff   */
/*		   nbyte)	/* local) or error			    */
/* FILE *f;				/* open connection		    */
/* void *buf;				/* buffer to read name into	    */
/* int nbyte;				/* size of buf (error if too small) */
/* ------------------------------------------------------------------------ */
BOOL net_readeor();
/* BOOL net_readeor(f)		/* iff last read was up to end of IDU, or   */
/*				/* connection changed reading state, TRUE   */
/* FILE *f;				/* open connection		    */
/* ------------------------------------------------------------------------ */

#endif
