#define ERRFMT(type, format, nargs) ((((nargs) * 4 + 10) << 24) \
				   | ((format) << 16) | (type))
/* bits defined for type field */
#define ERRUSER		0x8000	/* error is from user level code */
#define ERRDEVICE	0x4000	/* error is on a particular device */
/* these bits are defined for device driver errors */
#	define ERRHARD		0x2000	/* error was hard (off => soft) */
#	define ERRSOFT		0x0000
#	define ERRINFORM	0x1000	/* error was informative only */
					/* i.e., bug report */
#	define ERRREAD		0x0200	/* read error */
#	define ERRWRITE		0x0400	/* write error */
#	define ERRSPFUN		0x0600	/* error during spfun operation */
#	define ERRINIT		0x0800	/* during disk initialization */
#	define ERROTHER		0x0000	/* miscellaneous, use format to know*/

/* these bits are defined for other kernel errors */
#	define	ET_KBUG		0x0200	/* a kernel bug */
#	define	ET_FSPROB	0x0100	/* file system problem */
#	define	ET_TRANS	0x0080	/* a transient problem (no space) */

#include <sys/errlog_formats.h>
#include <sys/errlog_sources.h>
