/* list of all error log format numbers */
/* entries must have format number parenthesized, and printf string in
	following comment, with one blank after and before comment delimiters
 */
#define ECDC_IPC	(1)	/* IPC busy!! */
#define ECDC_NACK	(2)	/* NACK from controller */
#define ECDC_UEXPST	(3)	/* CDC: UNEXP STATUS */
#define ECDC_DERR	(4)	/* CDC: Disk err 0x%x */
#define ECDC_NBBF	(5)	/* CDC: NO BAD BLK FILE */
#define ECDC_TYPE	(6)	/* CDC: type <0x%x,0x%x> status 0x%x */

#define ECC1_REPORT	(8)	/* UNIT %d ERROR 0x%x FROM CC1 */
#define ECC1_RETRY	(9)	/* CC1: Error 0x%x retried on sector %d */
#define ECC1_ERROR	(10)	/* CC1: UNIT %d SECTOR %d ERROR 0x%x */
#define ECC1_UXI	(11)	/* CC1: Unexpected interrupt */
#define ECC1_NVR	(12)	/* CC1: No volume record */
#define ECC1_NBBF	(13)	/* CC1: No bad block record */
#define ECC1_NPBF	(14)	/* CC1: No partition record */
#define ECC1_SWTIME	(15)	/* CC1: Spinwait timeout */
#define ECC1_NODISK	(16)	/* CC1: No disk controller */
#define ELYNX_OFFLINE	(17)	/* LYNX OFFLINE */
#define ECC1_NINT	(18)	/* CC1: No interrupt in time */
#define ECC1_RESET	(19)	/* CC1: Software reset */
#define ECC1_SP		(20)	/* CC1: Strange partition 0 */

#define ER_SETTIME	(21)	/* time change: was %D, now %D (sec) */
#define ER_SPACE	(22)	/* SPACE? %d/%d */
#define	ER_BALLOC	(23)	/* BALLOC %D */
#define ER_BFREE	(24)	/* BFREE %D */
#define ER_FBNB		(25)	/* FREE BLOCK %D NOT BUSY */
#define ER_BND		(26)	/* BIOWAIT: NOT DONE %x */
#define ER_GBO		(27)	/* GETBUF: %X BASYNC WAS ON */
#define ER_GBTB		(28)	/* GETBUF TIMEOUT: BUF %x */
#define ER_GETFMATCH	(29)	/* getfile match err: f# %d fs# %d */
#define ER_GETFTYPE	(30)	/* getfile type: %d f# %d fs# %d */
#define ER_FREEFD	(31)	/* FREEFD: file %d fs %d NOT USED */
#define ER_FREEINDIR	(32)	/* freeindir: blk %d fs %d */

#define EIOP_ERROR	(33)	/* IOP read error %x */

#define EXE_RETRY	(34)	/* XE: Error 0x%x retried on sector %d */
#define EXE_ERROR	(35)	/* XE: UNIT %d SECTOR %d ERROR 0x%x */
#define EXE_UXI		(36)	/* XE: Unexpected interrupt */
#define EXE_NVR		(38)	/* XE: No volume record */
#define EXE_NBBF	(39)	/* XE: No bad block record */
#define EXE_NPBF	(40)	/* XE: No partition record */
#define EXE_NINT	(41)	/* XE: No interrupt in time */
#define EXE_RESET	(42)	/* XE: Software reset */
#define EXE_SP		(43)	/* XE: Strange partition 0 */
#define EXE_SWTIME	(44)	/* XE: Spinwait timeout */
