/*
	structure of a file descriptor

	8/12/83	 larry	added FDTAPE for tape drivers.
	01/20/83 john	Revisionist UNIX hackers added f_group and banished
			of_ocnt to system area!
	05/21/84 larry	Added contiguous file types, cache and allocation.

	Copyright (c) 1980 by Charles River Data Systems, Inc.
*/
#ifndef FDDEF
#define NSMALL		8
#define	MAXREFS		127	/* max refs for a single file descriptor */

/*  The file descriptor as it looks on the disk.  */
typedef struct file_desc
{
	short	f_type;			/* file type described below */
	short	f_device;		/* device, for device file */
	short	f_fileno;		/* file number on file system */
	short	f_flags;		/* flags defined below */
	GID	f_group;		/* group of owner */
	BLOCKNO	f_lastblk;		/* last block ref'd, for read ahead */
	long	f_size;			/* file size in bytes */
	BLOCKNO	smallmap[NSMALL];	/* array of block numbers */
	long	f_tmodified;		/* time last modified */
	short	f_fromfs;		/* file system filedesc is from */
	MODES	f_modes;		/* access modes */
	short	f_parent;		/* parent file, from filesys fromfs */
	UID	f_owner;		/* owner of file */
#ifdef M68000
	char	f_filler,		/* unused, presently */
		f_refcnt;		/* number of names in the fisystem */
#else
	char	f_refcnt,
		f_filler;
#endif
} FILEDESC;

/*  The file descriptor as it looks in the open FD array.  */
typedef struct open_file_desc
{
	short	of_type,		/* file type described below */
		of_device,		/* device, for device file */
		of_fileno,		/* file number on file system */
		of_flags;		/* flags defined below */
	GID	of_group;		/* group of owner */
	BLOCKNO	of_lastblk;		/* last block ref'd, for read ahead */
	long	of_size;		/* file size in bytes */
	BLOCKNO	of_smallmap[NSMALL];	/* array of block numbers */
	long	of_tmodified;		/* time last modified */
	short	of_fromfs;		/* file system filedesc is from */
	MODES	of_modes;		/* access modes */
	short	of_parent;		/* parent file, from filesys fromfs */
	UID	of_owner;		/* owner of file */
#ifdef M68000
	char	of_filler,		/* unused, presently */
		of_refcnt;		/* number of names in the fisystem */
#else
	char	of_refcnt,
		of_filler;
#endif
	short	of_ocnt;		/* open count, # of memory refs */
	struct locklist *
		of_locklist;		/* hook for record locking */
	char *of_cache[4];		/* 0 - last block */
					/* 1 - pointed to by small. */
					/* 2 - pointed to by 1 */
					/* 3 - pointed to by 2 */
	BLOCKNO	of_allocated;		/* location allocated */
	BLOCKNO	of_len;			/* # of blocks recently allocated */
} OPEN_FILEDESC;

/*
	file types
*/
#define UNUSED		0
#define SMALL		1
#define LARGE		2
#define CONTIGUOUS	3
#define UNBUFDEV	4
#define BUFDEV		5
#define HUGE		6
#define ECFILE		7
#define GARGANTUAN	8
#define	CSMALL		9
#define	CLARGE		10
#define	CHUGE		11
#define	CGARGANTUAN	12
#define FD_TYPE_MAX	12		/* current largest valid type number*/

/*
	flags definitions
*/
#define FMODIFIED	000001
#define FBUSY		000002
#define FDELETE		000004
#define FISADIR		000010
#define NOTADIR		((~FISADIR)&FISADIR)
#define FMOUNTED	000020
#define FILELOCKED	000040
#define FDLOCKED	000100
#define FVER2		000200
#define FDIRLOCKED	000400
#define FPIPE		001000
#define	FDTAPE		002000
#define FDEVOPEN	004000
#define FDWRITETHROUGH	010000
#define FTOUCHED	020000		/* for device fd's, like FMODIFIED */
#define FDWANTED	040000		/* because it's FDLOCKED (M-O-U-S-E)*/
#define FD_MAX_FLAG    0100000

/*
	macro definitions
*/
#define fsof(f)		((f)->of_fromfs)
#define devof(f)	((f)->of_device)
#define isdevice(f)	(f->of_type == BUFDEV || f->of_type == UNBUFDEV)
#define isec(f)		(f->of_type == ECFILE)
#define isdatafile(f)	(!isec(f) && !isdevice(f))
#define ispipe(f)	((f)->of_flags&FPIPE)
#define fdfileno(f)	((f)->of_fileno)
#define fdisdir(fd)	(((fd)->of_flags & FISADIR) == FISADIR)
#define FDDEF	1
#endif
