/*
	05/21/84 larry	Changed bit map table sizes to block size pieces.
 */

#define DISKDEV		0
#define NODEV		(-1)
#define ROOTDIRFNO	0
#define ROOTFSNO	0
#define TTYDEV		(1<<8)

#define SYSBSIZE	512
#define BINDSIZE	(SYSBSIZE/4)

#if OLDJUNK
#define NFDBLOCKS 	988
#define MAPSIZE	((NFDBLOCKS+15)/16)
#define NFDAVAIL	100
#define FDMAPSIZE	((NFDAVAIL+15)/16)
#endif

#define NFDBLOCKS 	(512*8)
#define MAPSIZE	((NFDBLOCKS+15)/16)
#define NFDAVAIL	(512*8)
#define FDMAPSIZE	((NFDAVAIL+15)/16)

#include <sys/filedesc.h>

struct file_sys
{
	long	fs_magic;
	long	fs_blmapaddr;
	BLOCKNO	fs_nblocks;
	long	fs_fdmapaddr;
	short	fs_nfds;
	long	fs_fdspace;
	long	fs_blspace;
};

#define devno(x) ((x)&0xFF)
#define FSMAGIC 0xEA1C1EFF
