/*  Definitions for the partition record of a disk drive.
    Created on June 1 January 1983 by Lawrence David Joseph Lopez.

	MODIFIED BY	REASON
	09/20/84 rfm	Allow 31 partitions.

    Copyright (c) 1983 by Charles River Data Systems, Inc.  */

# define part_block_id '.par'
# define part_block_address (0 * 512)



# define NPARTS 31

typedef struct partition
{	unsigned long	p_offset;	/* byte position of partition */
	unsigned long	p_limit;	/* first byte after partition */
} PARTITION;
typedef PARTITION PARTMAP [NPARTS];
typedef struct part_block_struct
{
	long part_id;			/*  Must contain '.par'  4 byte */
	char part_version;		/*  This is version 2.   1 byte */
	char part_number;		/*  Number of partitions 1 byte */
	char part_spare[2];		/*  spare 2 bytes */
	PARTMAP part_partmap;		/*  8*31 = 248 bytes */
} partition_record;
