
/*	Define the register values and space codes for the
	debugger routines pget() and pput().

	Copyright (c) 1985 by Charles River Data Systems, Inc.

	MODIFIED BY	REASON

	11/10/85  die	Created to document this presently unparameterized
			interface and add floating point (68881) registers

	12/14/85  die	Added RFPLOAD
	01/02/86  die	Added REG_FA

	Define the space codes (argument 1).  These differentiate
	amoung different possible spaces, and amoung various interpretations
	of the following two arguments to the call.  Argument 0 is the
	pid of the process being examined in all cases.
*/

#define UWSPACE			0

/*	This read-only space (U-area) contains much of the per process
	state information maintained for a process, including it's
	per-process system stack.  The contents of the U-area are defined
	in u.h and usually change with each new revision of the system.
	Thus the contents of this space should not be referenced except
	by revision dependant utilities locked to the kernal (such as ps).
	
	Argument 2 is the offset in bytes from the beginning of the U-area
	from which a 16 bit short value is to be copied.  Argument 3 points
	at a 16 bit short in the callers space which is to receive the
	value copied.
 */
#define USPACE			4

/*	This read-only space (U-area) contains much of the per process
	state information maintained for a process, including it's
	per-process system stack.  The contents of the U-area are defined
	in u.h and usually change with each new revision of the system.
	Thus the contents of this space should not be referenced except
	by revision dependant utilities locked to the kernal (such as ps).
	
	Argument 2 is the offset in bytes from the beginning of the U-area
	from which the data is to be copied.  Argument 3 points
	at a buffer in the callers space which is to receive the
	data copied.  Argument 4 is a count of the number of bytes to
	transfer.
 */


#define	MEMWSPACE	 	1		

/*	This space includes process text, data, stack, dseg, and
	physeg sections. Access is to one 16 bit word.
	Argument 2 (addr) is a pointer to the word to be read or written
	in the address space of the process with pid equal to argument 0.
	Argument 3 (wordp) is a pointer to a short in the caller's address
	space into which the data is to be read or from which it is to be
	written.
 */  

#define	MEMSPACE	 	5

/*	This space includes process text, data, stack, dseg, and
	physeg sections.  Access is to arbitrary strings of bytes.
	Argument 2 (addr) is a pointer to the start of the data to be read
	or written in the address space of the process with pid equal to
	argument 0.
	Argument 3 (putp/getp) is a pointer to the start of a buffer to 
	receive the data (pget) or from which the data originates (pput)
	in the caller's address	space.
	Argument 4 (size) is a count of the number of bytes to transfer
	to or from the process address space.
 */  

#define REGSPACE		2

/*	This space includes all the main processor registers and the floating
	point coprocessor control and status registers as well.  What is
	visible is the values of the registers at the time the process
	entered the system or was interrupted.  This information is
	valid only for suspended processes.  Actual register contents for
	processes executing in kernal space are currently found pushed
	on the bottem of the per-process system stack in the U area.

	Also included in this space are a number of process state variables
	accessible through this path so as to ensure compatibility with
	future revs of the system which may redefine where they are stored.

	Argument 2 specifies which register is to be returned or written.
	Argument 3 is a pointer to a long (32 bits) in caller's address space
	which gets the register value or from which the value to be put in
	the register is obtained. Reading and writing is of one int
	(32 bit integer).  Short values are suitably converted/truncated
	to unsigned longs.
 */

#define FPREGSPACE		3

/*	This space includes the 8 68881 extended precision floating point
	registers and the exceptional operand register.  Argument 2
	specifies which register is to be returned or written.  
	Argument 3 is a pointer to a 12 byte (3 long word) storage
	area for the extended precision floating point value. No
	conversion to or from the internal 80 bit format of the 68881
	registers occurs, the 80 bit floating point number is simply
	copied.  The exceptional operand register is in slightly
	different format and may not be written.
 */


/* 	Define the register numbers in REGSPACE */
/*	Values of n from 0 to 15 for the 68000/68020 access */
/* 	68000 register[n] as defined by Motorola's conventions */

#define	REG_D0		0		/* register d0 */
#define REG_D1		1		/* register d1 */
#define REG_D2		2		/* register d2 */
#define REG_D3		3		/* register d3 */
#define REG_D4		4		/* register d4 */
#define REG_D5		5		/* register d5 */
#define REG_D6		6		/* register d6 */
#define REG_D7		7		/* register d7 */
#define REG_A0		8		/* register a0 */
#define REG_A1		9		/* register a1 */
#define REG_A2		10		/* register a2 */
#define REG_A3		11		/* register a3 */
#define REG_A4		12		/* register a4 */
#define REG_A5		13		/* register a5 */
#define REG_A6		14		/* register a6 */
#define REG_A7		15		/* register a7, user stack pointer */


/*	Define the other 68000 registers visible in REGSPACE */

#define	REG_PC		16		/* PC while in user mode */
#define REG_PS		17		/* PS while in user mode */

/*	 Define the 68881 fpp control and status registers in REGSPACE */

#define REG_FPSTATE	18		/* fp state flag - further defined in
					   /include/sys/68881.h */
					/* 0 = null, -1 = not present, + value
					   means in use by process */
#define	REG_FPCR	19		/* fp command register */
#define REG_FPSR	20		/* fp status register */
#define REG_FPIAR	21		/* fp instruction address register */
#define	REG_FPOPA	22		/* fp operand address */
#define REG_FPBIU	23		/* fp internal state flags */
#define REG_FPCOMMAND	24		/* fp command code from state */
#define REG_FPOPERAND	25		/* fp operand word from state */ 

/*	Define additional process state for debuggers in REGSPACE*/

#define REG_TRAP	26		/* trap num (see trap.h) */
#define REG_SIGNAL	27		/* bit map of signals pending */
#define REG_SUSPEND	28		/* signal that caused suspend */
#define REG_FA		29		/* fault address on bus error
					   or odd address trap */
#define REG_MAX		29		/* largest legal code */

/*	The suspend signal number found with REG_SUSPEND reflects the
	signal or if several, the highest priority signal, that caused this
	process to suspend.

	Pending signals can be found with REG_SIGNAL.  These are a bit
	map of signals presently pending.	
*/

#ifndef U_AREA

#define offset(type, element) (int)(&((type *)0)->element)

#define regent(type,element,flags) (short)(&((type *)0)->element), (unsigned char)(sizeof(((type *)0)->element)), flags

/* Define flags for REGSPACE */

#define RWRITE		0x1	/* Allow write of this location */
#define RUAREA		0x2	/* Object is in U area */
#define RPROC		0x4	/* Object is in Process control block */
#define RFPLOAD		0x8	/* Writing to this changes 881 state */
/*  Define register table  */

#define REGENT {regent(U_AREA,u_regs[0],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[1],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[2],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[3],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[4],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[5],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[6],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[7],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[8],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[9],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[10],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[11],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[12],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[13],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[14],RWRITE|RUAREA)},\
{regent(U_AREA,u_regs[15],RWRITE|RUAREA)},\
{regent(U_AREA,u_pc,RWRITE|RUAREA)},\
{regent(U_AREA,u_ps,RWRITE|RUAREA)},\
{regent(U_AREA,u_fpstate.fpstate,RUAREA)},\
{regent(U_AREA,u_fpcr,RUAREA|RWRITE|RFPLOAD)},\
{regent(U_AREA,u_fpsr,RUAREA|RWRITE|RFPLOAD)},\
{regent(U_AREA,u_fpiar,RUAREA)},\
{regent(U_AREA,u_fpopa,RUAREA)},\
{regent(U_AREA,u_fpstate.biu,RUAREA|RWRITE|RFPLOAD)},\
{regent(U_AREA,u_fpstate.command,RUAREA)},\
{regent(U_AREA,u_fpstate.operand,RUAREA)},\
{regent(U_AREA,u_trap,RUAREA)},\
{regent(PROC,p_signals,RPROC)},\
{regent(PROC,p_status,RPROC)},\
{regent(U_AREA,u_fa,RUAREA)}\

#endif

/*	Define the register numbers in FPREGSPACE */

/* 	Note that the first 8 values are an array of the registers as
   	defined by the 68881 architecture and may be referenced as
   	by the Motorola register number */

#define	FP_REG0		0		/* fp register 0 */
#define	FP_REG1		1		/* fp register 1 */
#define	FP_REG2		2		/* fp register 2 */
#define	FP_REG3		3		/* fp register 3 */
#define	FP_REG4		4		/* fp register 4 */
#define	FP_REG5		5		/* fp register 5 */
#define	FP_REG6		6		/* fp register 6 */
#define	FP_REG7		7		/* fp register 7 */
#define FP_EXOP		8		/* fp exceptional operand */
#define FP_MAX		8		/* maximum legal register */

