/*
 *	The new physical volume header (NOW WITH TINT CONTROL!)
 *
 *	This stuff goes on the first 256 bytes of every hard disk
 *
 *
 *	MODIFIED BY	REASON
 *	01/02/86 wjr	Version 3. Make xe_bad_blocks fields general.
 *
 *	Copyright (c) 1983 by Charles River Data Systems, Inc.
 */


#define volume_block_id '.vol'
#define volume_block_address (0 * 512)
#ifdef TEST
#define current_version 127
#else
#define	current_version 3
#endif
#define PVHSIZE sizeof(PVH)
#define NAMESIZE 23	/* The size of the volume type name */

typedef struct sc_three
{
	unsigned short luddr;
	unsigned short  huddr;
} SCT;

typedef struct assign_disk_param
{	char step_width, step_period, step_mode;
	char max_head;
	short max_cyl;
	char reduce_write_cyl;
	char drive_type;		/*  0 for Winchester.  */
	char secs;			/*  0 for DTC535.  */
	char reserved;
} ADP;

typedef struct physical_volume_header
{
/* 0x00: */
	long	pvh_id;			/* always contains '.vol' */
/* 0x04: */
	char	pvh_version;		/* This is version 2 */
/* 0x05: */
	char	pvh_spt;		/* Number of sectors per track */
/* 0x06: */
unsigned short	pvh_secshift;		/* fed to the unit table */
/* 0x08: */
	short	pvh_tpc;		/* Number of tracks per cylinder */
/* 0x0A: */
	ADP	pvh_adp;		/* compiled controller info */
/* 0x14:				Next value MUST be at 0x14	*/
	long	pvh_boot_sector;	/* starting sector number */
/* 0x18: */
	short	pvh_boot_count;		/* number of sectors */
/* 0x1C: */
	long	pvh_twospace;		/* MUST BE ZERO */
/* 0x1E: */
	char	pvh_pad[0x5E-0x1E];	/* Extra space for future use */
/* 0x5E: */
	long	pvh_option1;		/* device dependant parameters 1-3 */
/* 0x62: */
	long	pvh_option2;
/* 0x66: */
	long	pvh_option3;
/* 0x6A: */
	SCT	pvh_sct;		/* Parameters for the SC3011 */
/* 0x6E: */
	char	pvh_device_name[22];	/* The name of the device */
/* 0x84:				NEXT TWO LONGS MUST BE AT 0x84 */
	long	pvh_dump_partition[2];	/* 24336 * 2. Ask Larry. */
				        /* 2000 * 2 << 16. He might know. */
/* 0x8C: */
	char	pvh_drive_name[23];	/* Name of drive type */
/* 0xA3: */
	char	pvh_extra[0xE4-0xA3];	/* Do anything you like with these */
/* 0xE4: */
	short	pvh_recovery;		/* interleave recovery time */
/* 0xE6: */
	short	pvh_interleave;		/* interleave factor */
/* 0xE8: */
	long	pvh_bb_block;		/* Absolute block number of */
/* 0xEC: */				/* bad block list. */
	long	pvh_bb_length;		/* and the length thereof (blocks)*/ 
/* 0xF0: */
	char	pvh_ctlrn[8];		/* The controller name */
/* 0xF8: 				This MUST BE at F8 */
	char	pvh_VOLID[8];		/* the magic word UNBUG */
/* 0x100:			DONE				Yipee! */
} PVH;
