#ifndef UADDR
#include <sys/stypes.h>
#endif
#ifndef FP
#include <sys/68881.h>
#endif

/*
	Define format of information that gets stuffed on user stack
	when a signal or event call happens.  This user space information
	is available to a user handler via a pointer to this signal
	information structure passed as argument 3 to the signal or eventcall.

			^				^
			|	Stack in use by		|
			|	interrupted process	|
			*********************************
			|       0x00000001 Marker	|
			|	for raise routine	|
			---------------------------------
			|       0x00000001 Marker	|
			|	for raise routine	|
Top of signal frame	=================================
			|	Optional 68881 floating	|
			|	point info if in use -	|
			|	includes FP0 and FP1	|
			|	and fpcr, fpsr, and	|
			|	fault info.		|
			---------------------------------
			|	Main body of signal	|
			|	save frame, contains	|
			|	pc to return to, usp, 	|
			|	ps, and d0,d1,a0,a1 	|
			|	plus UNOS error info.	|
Base of signal frame	=================================<------|
			|	System call instruction	|<--------------|
			|	Resindx system call	|	|	|
			|-------------------------------|	|	|
			|	Arg 3 to user handler	|	|	|
			|	points to signal frame	|-------|	|
			|-------------------------------|		|
			|	Arg 2 to user handler	|		|
			|	pc at time of signal	|		|
			|	Lu of event that caused	|		|
			|	eventcall		|		|
			|-------------------------------|		|
			|	Arg 1 to user handler	|		|
			|	Signal number		|		|
			|	Event count value	|		|
			|-------------------------------|		|
			|	"Return pc", points	|---------------|
			|	to Resindx system call	|
			*********************************
			|				|
			|	Frame pointer and 	|
			|	args pushed by signal	|
			|	handler			|
			
			
	Modification of the machine state on return from the signal or
	event call is possible, and can be accomplished by changing 
	the contents of the appropriate field in this structure.

	The user is warned, however, that CRDS regards this interface
	as subject to change.

	Copyright (c) 1985 by Charles River Data Systems, Inc.

	MODIFIED BY	REASON

	11/1/85  die	Created to document this interface for the first time.
			68881 information added to previous (undocumented)
			structure.
	12/14/85 die	Upgraded to include version number

*/


	struct	signalframe
{
	UADDR	s_usp;		/* user stack pointer on return from handler*/
	UPC	s_pc;		/* pc to resume at on return from handler */
	short	s_ps;		/* ps when execution resumed */
	short	s_version;	/* Version number of this rev of signalframe*/

/* Define the version number of this signalframe structure */

#define	SIGNALFRAME_VERSION	1	/* 12/14/85 Version */

	long	s_trap;		/* UNOS trap code if this signal caused by */
				/* a trap, otherwise 0 */
	long	s_new_traps;	/* bitmap of trap signals for which this state
				   is valid base level trap state */
	long	s_errno,	/* save area for errno (UNIX error code) */
		s_error,	/* save area for system error code */
		s_d0,		/* save area for d0 */
		s_d1,		/* save area for d1 */
		s_a0,		/* save area for a0 */
		s_a1;		/* save area for a1 */

	/*  Following word contains fault address (bus errors) or
	    address of instruction causing trap (on 68020 only)
	    is null pointer for 68000 traps */

	UPC		s_fa;		/* fault address */

	/*  following  word is zero if floating point state is null */

	FPSTATE		s_fpstate;	/* size + version number from chip */

	/*  following floating point state information is valid only if
	    fp state is idle rather than null */

	unsigned long  s_fpbiu;		/* floating point chip idle flags 
				  	   meaning depends on s_fpstate */
	unsigned long	s_fpcr,		/* fp command register */
			s_fpsr;		/* fp status register */
	UPC		s_fpiar;	/* fp interrupt address register */
	FPREG		s_fp0,		/* save area for FP0 */
			s_fp1;		/* save area for FP1 */
	UADDR		s_fpopa;	/* fp operand address */
	FPREG		s_fpexop;	/* exceptional operand */
};

typedef struct signalframe SIGNALFRAME; 
