/*
	special functions

	MODIFIED BY	REASON
	01/23/86 tdh	add WACCEPTEDEC, modification record
	02/06/86 rfm	Add UNLOAD, READMULTIFMS for SASI 1/2" tape.
	04/22/86 rfm	Add FIONWRITE, label REINIT suitable for TTYs.
	06/23/86 rfm	Make sure READFILEMARK is same number as last release.

	Copyright (c) 1986 by Charles River Data Systems, Inc.
*/
#define FIOCLEX		(('f'<<8)|1)		/* close this LUN on exec */
#define FIONCLEX	(('f'<<8)|2)		/* no, I take it back... */

#define GTTYCALL	1		/*  TTYs  */
#define STTYCALL	2
#define GTTY		1		/*  spfun (..., GTTY, &TTYMODES);  */
#define STTY		2
#define GETEC		4		/*  Many drivers - use ecget()  */
#define NAMEEC		5		/*  For kernel internal use  */
#define FLUSHIN		6		/*  TTYs  */
#define REINIT		7		/*  Disk, tape, TTY drivers  */
#define GERKL		8		/*  TTYs  */
#define SERKL		9		/*  spfun (..., SERKL, &erkl);  */
#define FORMAT		10		/*  Disk, tape drivers  */
					/*  spfun (..., FORMAT, interleave); */
#define	ASYNCCMD	11		/*  Tape drivers  */
#define	ASYNCTEST	12
#define	ASYNCWAIT	13
#define	ASYNCNBUF	14
#define	SETBLOCKSIZE	15
#define	GETBLOCKSIZE	16
#define UTILITY		21
#define TM_24BIT	24		/* is TAPEMASTER in 24 bit mode? */
#define TM_SETDEBUG	25		/* turn on/off TM debugging */

#define	GETBREAKS	16		/*  TTYs  */
#define	SETBREAKS	17		/*  spfun (..., SETBREAKS, &char_array,
							sizeof char_array);  */
#define FLUSHOUT	18
#define GETSPCHAR	19		/*  spfun (..., GETSPCHAR, &SPCHAR); */
#define SETSPCHAR	20
#define GETTTYSTATE	21		/*  spfun (..., GETTTYSTATE,	     */
#define SETTTYSTATE	22		/* &TTYSETSTATE, sizeof TTYSETSTATE);*/
#define FIONREAD	23		/*  spfun (..., FIONREAD, &avail); */
#define FIONWRITE	24		/*  spfun (..., FIONWRITE, &avail);  */

/* Op codes for CDC driver */
#define GETSTATS2	61		/* get statistics */
#define SORTON		62		/* elevator up	  */
#define SORTOFF		63		/* elevator down  */

/*	Op codes for CC1 driver  */
#define GETSTATS	60		/*  Get device statistics.  */
#define RESET		61		/*  Reset the CC-1 and controller.  */
#define SETRETRY	62		/*  Set error retry mode/count.  */
#define GETERROR	63		/*  Get most recent error code.  */
#define SENDCMD		64		/*  Send arbitrary command to ctlr.  */
#define SETCTLR		65		/*  Set arbitrary controller type.  */
	/* Mostly for SASI bus tape: */
#define	WRITEFILEMARK	66		/*  Write N filemarks on tape.  */
#define READMULTIFMS	67		/*  Skip to N adjacent filemarks.  */
#define	READFMASYNC	68		/*  Skip N filemarks, don't wait.  */
#define	READFILEMARK	69		/*  Skip N filemarks on tape.  */
#define	REWIND		70		/*  Reposition to beginning of tape. */
#define GETCTLRTYPE	71		/*  Determine controller type.  */
#define ERASE		72		/*  Run tape past erase head.  */
#define	SETPVH		73		/*  Hand driver a PVH image to use.  */
#define UNLOAD		74		/*  Prepare tape for removal.  */
	/* XYLOGICS driver only */
#define READABS		77		/*  Read a sector, no bad block map  */
#define WRITEABS	78		/*  Write a sector, no bad block map */
	/* IOP serial ports: */
#define	SETSTATE	80		/* obsolete - use SETTTYSTATE */
#define GETSTATE	81		/* get TTY device characteristics */
#define SETSYNCH        90              /* set device characteristics */
                                        /* for synch communications   */
	/* VME IOP special functions: */
#define SETVMEINIT	100		/* Initialization of VME IOP */

/*
	Eventcount names for use with ecget().  (Formerly used GETEC spfun.)
*/
#define LEGITEC		2	/* number of arrived read events */
#define ACCEPTEDEC	4	/* number of disposed read events */
#define WACCEPTEDEC	6	/* number of disposed write events */
