/*  File status structure for UNIX compatibility library.  */

struct stat
{	dev_t		st_dev;
	ino_t		st_ino;
	unsigned short	st_mode;
	short		st_nlink;
	short		st_uid;
	short		st_gid;
	dev_t		st_rdev;
	off_t		st_size;
	time_t		st_atime;
	time_t		st_mtime;
	time_t		st_ctime;
};

#define S_IFMT		0170000		/*  File type, as follows:  */
#define	  S_IFDIR	0040000		/*  Directory  */
#define	  S_IFCHR	0020000		/*  Character unbuffered  */
#define	  S_IFBLK	0060000		/*  Character buffered  */
#define	  S_IFREG	0100000		/*  'Regular' file  */
#define	  S_IFMPC	0030000		/*  No multiplexed files on UNOS  */
#define	  S_IFMPB	0070000		/*  Ditto  */
#define	  S_IFIFO	0010000		/*  FIFO (named pipe) */
#define	  S_IFEVC	0170000		/*  Eventcount file - not on UNIX  */

#define S_ISUID		0004000	
#define S_ISGID		0002000	
#define S_ISVTX		0001000	
#define S_IREAD		0000400		/*  Owner read permission  */
#define S_IWRITE	0000200		/*  Owner write permission  */
#define S_IEXEC		0000100		/*  Owner execute/search permission */

/* SYSTEM V new definitions */
/* macro to test for block special file */
#define S_ISBLK(mode)	(((mode)&S_IFMT)==S_IFBLK)
/* macro to test for character special file */
#define S_ISCHR(mode)	(((mode)&S_IFMT)==S_IFCHR)
/* macro to test for directory file */
#define S_ISDIR(mode)	(((mode)&S_IFMT)==S_IFDIR)
/* macro to test for FIFO special file */
#define S_ISFIFO(mode)	(((mode)&S_IFMT)==S_IFIFO)
/* macro to test for regular file */
#define S_ISREG(mode)   (((mode)&S_IFMT)==S_IFREG)

/* #define S_ENFMT		/* record locking enforcement flag */
#define S_IRWXU	    0700	/* read, write, execute: owner */
#define S_IRUSR	    0400	/* read permission: owner */
#define S_IWUSR	    0200	/* write permission: owner */
#define S_IXUSR	    0100	/* execute permission: owner */
#define S_IRWXG	    0070	/* read, write, execute: group */
#define S_IRGRP	    0040	/* read permission: group */
#define S_IWGRP	    0020	/* write permission: group */
#define S_IXGRP	    0010	/* execute permission: group */
#define S_IRWXO	    0007	/* read, write, execute: other */
#define S_IROTH	    0004	/* read permission: other */
#define S_IWOTH	    0002	/* write permission: other */
#define S_IXOTH	    0001	/* execute permission: other */
