#ifndef STYPEDEF
typedef char	*pointer;
typedef	long	PID;
typedef long	BUSADDR;
typedef	char	*UADDR;
typedef char	*KADDR;
typedef short	*UPC;		/* user pc is word aligned */
typedef short	*KPC;		/* kernel pc is word aligned */
typedef unsigned short	UID;
typedef unsigned short	GID;
typedef long	PSIZE;

#define GETDEVSW(W) (devsw[(W).d_major&0x3F])      /* where W is devtype */

typedef unsigned short devtype;
typedef struct { unsigned char d_major, d_minor; } DEVICE;

typedef long	BLOCKNO;

typedef unsigned short modetype;
typedef unsigned short MODES;

#define MSUID		4	/* set euid on exec */
#define MSGID		2	/* set egid on exec */
#define MSVTX		1	/* save text on swap after exit */

#ifdef __WHITESMITH

/* WHITSMITHS C COMPILER ALLOCATES BIT FIELDS FROM THE LEAST SIGNIFICANT BIT
   OF AN INT, HENCE, THIS STRUCTURE GETS LAID OUT IN MEMORY AS

   31	         1615             0	Bit number
  ---------------------------------
  | X | D | G | O |     _x_x_x    |
  ---------------------------------
  0        1       2       3		Byte number
*/


struct modestruct {			/* kludgy structure, must be used */
	unsigned	_x_x_x:16,	/* without cc -m flag */
			mode_o:4,
			mode_g:4,
			mode_d:4,
			mode_x:4;
};

#else

struct modestruct {
	unsigned	
			mode_x:4,
			mode_d:4,
			mode_g:4,
			mode_o:4;
};

#endif

/* The following macros take a short word and mask off pieces reliably */
#define MODE_X(s)	(((s) >> 12)& 0xf)
#define MODE_D(s)	(((s) >> 8) & 0xf)
#define MODE_G(s)	(((s) >> 4) & 0xf)
#define MODE_O(s)	(((s)     ) & 0xf)

#ifdef	OLD_UID
#ifdef M68000
typedef struct
{
	unsigned char	mode_d,		/* default modes */
			mode_o;		/* owner modes */
}	modetype;
#else
typedef struct
{
	unsigned char	mode_o,		/* owner modes */
			mode_d;		/* default modes */
}	modetype;
#endif
typedef unsigned short MODES;
#endif OLD_UID
#define STYPEDEF	1
#endif
