/*
 * Special function calls for TapeMaster tape driver
 */
#define	ASYNCCMD	11		/*  Tape drivers  */
#define	ASYNCTEST	12
#define	ASYNCWAIT	13
#define	ASYNCNBUF	14
#define	SETBLOCKSIZE	15
#define UTILITY		21
#define	TM_ASYNC	23		/* put tape driver into async mode */
#define TM_24BIT	24		/* is TAPEMASTER in 24 bit mode? */

	/* UTILITY CODES */

#	define	NOCLOSE		-1	/* no close action */
#	define	SETEOT		-2	/* set eot pointer */
#		define INF	65535	/* the "infinite" block */
#	define	SETREC		-3	/* set record pointed */

#	define NOP		0x20
#	define DRIVESTATUS	0x28
#	define DRIVERESET	0x90
#	define SETRETRY		0x8C
#	define DENSITY		0xA0		/* for setting density. */
						/* recs0 == 0 HI, 1 LO */
#	define OFFLINE		0x38
#	define REWIND		0x34
#	define OVERLREWIND	0x04
#	define WRITETM		0x40
#	define SPACE		0x48
#	define SPACEFM		0x70
#	define SEARCHFM		0x44
#	define SEARCHMULTIPLE	0x94
#	define ERASETAPE	0x50
#	define ERASEFIXED	0x4C

	/* drive status bits */
#define S_WPROTECT	0x2	/* write protect */
#define S_FB		0x4	/* formatter busy */
#define S_RDY		0x8	/* tape unit ready */
#define S_EOT		0x10	/* end of tape */
#define S_LOAD		0x20	/* load point */
#define S_ONLINE	0x40	/* on-line */
#define S_EOF		0x80	/* end of file */
#define S_NORMAL	(S_RDY|S_ONLINE)
#define S_END		(S_EOF|S_EOT)
#define S_CHECK		(S_END|S_NORMAL)
