/*	Define the trap codes returned by the exception handling routines
	and define their mapping into UNIX signals.  Define the messages
	printed by the debugger and system when a trap happens.  



	Copyright (c) 1985 by Charles River Data Systems, Inc.

	MODIFIED BY	REASON

	11/14/85  die	Created to document this part of UNOS and add
			68881 traps.

*/

#ifndef SIGTERM
#include <signal.h>
#endif

/*	Define the trap codes for UNOS.  These specify why execution of the
	current user or system context was interrupted.  They are only
	meaningful when the interruption was caused by a synchronous
	trap due to some exception condition arising within the program rather
	than by an IO interrupt assynchronous to the program.

	Within the kernal, these codes are stored on the supervisor stack
	as part of an exception frame.  When a process suspends or is
	suspended by receiving a signal which it doesn't catch, the trap code
	for the trap that last caused it to exit user mode is saved in u_trap
	in the U-area along with the process registers. 

 	These trap codes are visible to user programs through the pget()
	debugger interface subroutine, and as part of the signalframe
	structure pushed on the user's stack when a signal or eventcall
	interrupts a user process.

	These codes are unique to 68000 family UNOS and are subject to slight
	changes and additions from time to time as new processors are
	supported by the system.

*/

#define	TINTR		0		/* Device interrupt - not a trap */
					/* Must be defined as zero */
#define	TILL		1		/* Illegal instruction */
#define TTRACE		2		/* Breakpoint/trace */
#define TIOT		3		/* PDP-11 IOT instruction not used */
#define	TPWR		4		/* Power fail - not currently used */
#define	TSCALL		5		/* System call */
#define	TTRAP		6		/* Trap 2- 14 instructions */
#define	TPAR		7		/* Parity error - not presently used */
#define TSKY		8		/* Sky floating point */
#define	TBUS		9		/* Bus error */
#define	TSEGV		10		/* Memory management */
#define	TODD		11		/* Odd address trap */
#define	TZDIV		12		/* Divide by zero */
#define TCHK		13		/* CHK instruction trap */
#define	TOVER		14		/* Overflow */
#define TPRIV		15		/* Privileged instruction */
#define	TFLINE		16		/* Illegal coprocessor inst */
#define TCOPR		17		/* Coprocessor protocol violation */
#define	TFMT		18		/* Bad state on restore state */
#define	TBSUN		19		/* 68881 unordered exception */
#define	TINEX		20		/* 68881 inexact exception */
#define	TDZ		21		/* 68881 div by zero exception */
#define TUNFL		22		/* 68881 underflow exception */
#define	TOPERR		23		/* 68881 invalid operand exception*/
#define	TOVFL		24		/* 68881 overflow exception */
#define	TSNAN		25		/* 68881 signalling NAN */
#define TMAX		25		/* Largest defined trap number */

/*	Note that all of the following trap related definitions are
	ordered by trap number and any changes in trap numbers must be
	reflected in all of these definitions .  The person
	who modifies trap numbers is also warned that, at present, 
	trap numbers are also defined in c20low.m, c32low.m, and mch.m.
*/

	
/* Define the messages printed by UNOS and the debugger for the traps */

#define TRAPSTRINGS \
"device interrupt",\
"illegal instruction",\
"bpt/trace",\
"iot",\
"power fail",\
"system call",\
"trap instruction",\
"parity error",\
"sky floating pt",\
"bus error",\
"memory management",\
"odd address",\
"div by 0",\
"CHK instruction",\
"overflow",\
"privilege",\
"illegal cp instruction",\
"coprocessor protocol",\
"invalid restore format",\
"floating pt unordered",\
"floating pt inexact",\
"floating pt div by 0",\
"floating pt underflow",\
"floating pt operand err",\
"floating pt overflow",\
"floating pt signaling NAN"

/* Define the UNIX/UNOS signal numbers into which each trap condition maps */
/* 0 means that this trap causes a system panic if it gets to trap.c */

#define TRAPSIGNALS \
0,		/*  TINTR - fatal should never reach trap.c */\
SIGILL,		/*  TILL  */\
SIGTRAP,	/*  TTRACE  */\
SIGIOT,		/*  TIOT  */\
0,		/*  TPWR  - fatal - subject to change*/\
0,		/*  TSCALL - fatal should never reach trap.c */\
SIGEMT,		/*  TTRAP  */\
SIGBUS,		/*  TPAR  */\
SIGFPE,		/*  TSKY */\
SIGBUS,		/*  TBUS  */\
SIGSEGV,	/*  TSEGV */\
SIGBUS,		/*  TODD */\
SIGILL,		/*  TZDIV  */\
SIGILL,		/*  TCHK */\
SIGILL,		/*  TOVER  */\
SIGILL,		/*  TPRIV  */\
SIGILL,		/*  TFLINE */\
SIGBUS,		/*  TCOPR */\
0,		/*  TFMT - fatal as can only happen in system code */\
SIGFPE,		/*  TBSUN */\
SIGFPE, 	/*  TINEX */\
SIGFPE,		/*  TDZ */\
SIGFPE,		/*  TUNFL */\
SIGFPE,		/*  TOPERR */\
SIGFPE,		/*  TOVFL */\
SIGFPE		/*  TSNAN */

