/*
	structures for setting terminal modes
 */

#ifndef TTY_MODES
#include <sys/spfun.h>

struct ttymode		/*  Use with spfun (..., STTY, &TTYMODES);  */
{
#ifdef __WHITESMITH
	unsigned	t_wakealpha:1,	/* wakeup on every alpha char */
			t_wakectl:1,	/* wakeup on every control char */
			t_i8bit:1,	/* dont mask top bit on input */
			t_prctl:1,	/* enable process control ^Y, ^C */
			t_scrctl:1,	/* enable screen control ^S ^Q ^L */
			t_escape:1,	/* enable escape processing */
			t_eof:1,	/* enable ^D -> EOF mapping */
			t_icrlf:1,	/* enable mapping of CR to LF input */
			t_ealpha:1,	/* echo alpha chars */
			t_ectl:1,	/* echo ctl as ^X */
			t_erawctl:1,	/* echo ctl as itself */
			t_etab:1,	/* echo tabs (how ? like oxtab) */
			t_ecrlf:1,	/* echo LF as CR LF pair */
			t_o8bit:1,	/* dont and top bit on output */
			t_octl:1,	/* prettyprint control chars */
			t_ocrlf:1,	/* print LF as CRLF */
			t_oxtab:1,	/* expand tabs on output */
			t_nowait:1,	/* dont wait to set modes */
			t_irawedit:1,	/* pass editing chars DEL, ^U, ^R */
			t_enobellerr:1,	/* dont output BEL when DEL & no input,
					   or when input buffer overflows */
			t_printing:1,	/* dont backspace for DEL, ESC */
			t_wakenl:1,	/* wake up on newline char */
			t_wakeblock:1,	/* block mode reads */
			t_unused:9;
#else
	unsigned	t_unused:9,
			t_wakeblock:1,	/* block mode reads */
			t_wakenl:1,	/* wake up on newline char */
			t_printing:1,	/* dont backspace for DEL, ESC */
			t_enobellerr:1,	/* dont output BEL when DEL & no input,
					   or when input buffer overflows */
			t_irawedit:1,	/* pass editing chars DEL, ^U, ^R */
			t_nowait:1,	/* dont wait to set modes */
			t_oxtab:1,	/* expand tabs on output */
			t_ocrlf:1,	/* print LF as CRLF */
			t_octl:1,	/* prettyprint control chars */
			t_o8bit:1,	/* dont and top bit on output */
			t_ecrlf:1,	/* echo LF as CR LF pair */
			t_etab:1,	/* echo tabs (how ? like oxtab) */
			t_erawctl:1,	/* echo ctl as itself */
			t_ectl:1,	/* echo ctl as ^X */
			t_ealpha:1,	/* echo alpha chars */
			t_icrlf:1,	/* enable mapping of CR to LF input */
			t_eof:1,	/* enable ^D -> EOF mapping */
			t_escape:1,	/* enable escape processing */
			t_scrctl:1,	/* enable screen control ^S ^Q ^L */
			t_prctl:1,	/* enable process control ^Y, ^C */
			t_i8bit:1,	/* dont mask top bit on input */
			t_wakectl:1,	/* wakeup on every control char */
			t_wakealpha:1;	/* wakeup on every alpha char */
#endif
};
typedef struct ttymode TTYMODE;
#ifdef __WHITESMITH
#define DEFAULT_TTY_MODES {0,0,0,1,1,1,1,1,1,1,0,1,1,0,0,1,1,0,0,0,0,1,0}
#define NOECHO_TTY_MODES  {0,0,0,1,1,1,1,1,0,0,0,0,1,0,0,1,1,0,0,0,0,1,0}
#else
#define DEFAULT_TTY_MODES {0,0,1,0,0,0,0,1,1,0,0,1,1,0,1,1,1,1,1,1,1,0,0,0}
#define NOECHO_TTY_MODES  {0,0,1,0,0,0,0,1,1,0,0,1,0,0,0,0,1,1,1,1,1,0,0,0}
#endif
#define CLEAR_ECHO_MODES(mode) { mode.t_ealpha=0; mode.t_ectl=0; \
	mode.t_erawctl=0; mode.t_etab=0; mode.t_ecrlf=0; }
#define UNIX_RAW_MODES(mode) { mode.t_wakealpha=1; mode.t_wakectl=1; \
	mode.t_wakenl=1; mode.t_i8bit=1; mode.t_prctl=0; \
	mode.t_scrctl=0; mode.t_escape=0; mode.t_eof=0; \
	mode.t_o8bit=1; mode.t_octl=0; \
	mode.t_oxtab=0; mode.t_irawedit=1; }
#define UNIX_RAW_MODES_V7(mode) { mode.t_wakealpha=1; mode.t_wakectl=1; \
	mode.t_wakenl=1; mode.t_i8bit=1; mode.t_prctl=0; \
	mode.t_scrctl=0; mode.t_escape=0; mode.t_eof=0; \
	mode.t_icrlf=0; mode.t_o8bit=1; mode.t_octl=0; \
	mode.t_ocrlf=0; mode.t_oxtab=0; mode.t_irawedit=1; \
	mode.t_ecrlf=0; }
#define UNIX_COOKED_MODES(mode) { mode.t_wakealpha=0; mode.t_wakectl=0; \
	mode.t_wakenl=1; mode.t_i8bit=0; mode.t_prctl=1; \
	mode.t_scrctl=1; mode.t_escape=1; mode.t_eof=1; \
	mode.t_o8bit=0;  mode.t_irawedit=0; }

typedef struct		/*  Use with spfun (..., SERKL, &erkl);  */
{
	unsigned char erkl_erasech;	/* current character erase char */
	unsigned char erkl_linedelch;	/* current line kill char */
} erkl;

#define DEFAULT_ERKL {'\177','\025'}	/* DEL, ^U */


typedef struct		/*  Use with spfun (..., SETSPCHAR, &SPCHAR);  */
{
	unsigned char 	spc_stop,	/* ^S or equivalent */
			spc_start,	/* ^Q or equivalent */
			spc_kill,	/* ^C or equivalent */
			spc_suspend,	/* ^Y or equivalent */
			spc_delete,	/* DEL or equivalent */
			spc_linekill,	/* ^U or equivalent */
			spc_retype,	/* ^R or equivalent */
			spc_eof,	/* ^D or equivalent */
			spc_escape;	/* ESC or equivalent */
} SPCHAR;

#define DEFAULT_SPCHAR \
	{ '\023','\021','\003','\031','\177','\025','\022','\004','\033' }
        /*  ^S     ^Q     ^C     ^Y     DEL    ^U     ^R     ^D     ESC */

#define TTY_MODES
#endif
