/*
	set state structure for terminals
	Use with spfun (..., SETTTYSTATE, &TTYSETSTATE, sizeof TTYSETSTATE);
 */

typedef struct{
	char	ss_bri,			/* input baud rate */
		ss_bro,			/* output baud rate */
		ss_wl,			/* word length: 5,6,7,8 - asynch */
					/* station address   - synch */	

		ss_parity,		/* parity type       - asynch */
					/* NRZI/NRZ          - synch */

		ss_stop,		/* stop bits         - asynch*/
					/* synch state       - synch */

		ss_rts,			/* rts control       - asynch */
					/* full/half duplex  - synch */
 
		ss_mode;		/* communication mode - asynch */
					/*                    - sdlc   */
					/*                    - bsc    */ 
	} TTYSETSTATE;

/*  Communication modes (ss_mode):  (controls meaning of other fields)  */
#define SSASYNCH	0
#define SSSDLC		1
#define SSBISYNC	2

/*  Baud rates (ss_bri, ss_bro):  */
#define	SSBRHANG	0	/* hang up a modem */
#define	SSBR50		1
#define	SSBR75		2
#define	SSBR110		3
#define	SSBR134V5	4
#define	SSBR150		5
#define	SSBR200		6
#define	SSBR300		7
#define	SSBR600		8
#define	SSBR1200	9
#define	SSBR1800	10
#define	SSBR2400	11
#define	SSBR4800	12
#define	SSBR9600	13
#define	SSBR19200	14
#define	SSBR38400	15
#define	SSBREXTDIV16	16
#define	SSBREXT		17
#define	SSBRAUTO	18

/*  Input and output parity modes (ss_parity when ss_mode == SSASYNCH):  */
#define	SSIOEVEN	0
#define	SSIOODD		1
#define	SSIOMARK	2
#define	SSIOSPACE	3
#define	SSOEVEN		4
#define	SSOODD		5
#define	SSOMARK		6
#define	SSOSPACE	7
#define	SSNOPARITY	8

/*  Serial encoding (ss_parity when ss_mode != SSASYNCH):  */
#define SSNRZ		0
#define SSNRZI		1

/*  RTS control modes (ss_rts when ss_mode == SSASYNCH):  */
#define	SSRTSOFF	0
#define	SSRTSON		1
#define	SSRTSNOTEMPTY	2
#define	SSRTSNOTFULL	3

/*  Full/half duplex modes (ss_rts when ss_mode != SSASYNCH):  */
#define SSHALFDUP	0x02	/* bit mask for RTS bit in SCC WR5 */
#define SSFULLDUP	0

/*  Number of data bits (ss_wl when ss_mode == SSASYNCH):  */
#define	SS5BIT		5
#define	SS6BIT		6
#define	SS7BIT		7
#define	SS8BIT		8

/*  Number of stop bits (ss_stop when ss_mode == SSASYNCH):  */
#define	SS1STOP		1
#define	SS1V5STOP	2
#define	SS2STOP		3

#define	DEFAULT_TTY_SETSTATE	{SSBR9600,SSBR9600,SS8BIT,SSNOPARITY,\
	SS1STOP, SSRTSON, SSASYNCH}

/* UNOS to UNIX speed conversion macros */
#define SPEED_J_TO_U(S) (S > SSBR38400 ? SSBR38400 :S)
#define SPEED_U_TO_J(S) (S)
