/*
	include file <unistd.h>

	date	 who	reason
	07/25/84 jeff	created for /usr/group compatibility
	09/05/84 rfm	Added contig file constants per Marc Teller proposal.
*/
/* symbolic constants for the "access" function */
#define R_OK	4	/* Test for Read Permission */
#define W_OK	2	/* Test for write permission */
#define X_OK	1	/* Test for execute permission */
#define F_OK	0	/* test for existance of file */

/* symbolic constants for lockf() */
#define F_ULOCK	0	/* unlock a region */
#define F_LOCK	1	/* lock a region and wait if necessary */
#define F_TLOCK	2	/* lock a region but do not wait if needed */
#define F_TEST	3	/* test for an existing lock */

/* symbolic constants for lseek() */
#define SEEK_SET	0	/* set file pointer to offset */
#define L_SET	    SEEK_SET	/* SYSTEM V name */
#define SEEK_CUR	1	/* set file pointer to current + offset */
#define L_CUR	    SEEK_CUR
#define SEEK_END	2	/* set file pointer to EOF + offset */
#define L_END	    SEEK_END

/* pathnames of the password file and group file */
#define GF_PATH	"/etc/group"
#define PF_PATH	"/etc/passwd"
#define IN_PATH "/include"

/* structure for utime() */
struct utimbuf
{
	time_t	actime;		/* date and time of last access */
	time_t	modtime;	/* date and time of last modification */
};

/* parameters of contiguous files */
#define MXIEXT 0x7FFFFFFFL	/* maximum size (bytes) of first extent */
#define MXSEXT 0x7FFFFFFFL	/* maximum size (bytes) of other extents */
#define MXNEXT (3*64*64*64)	/* maximum number of extents */
#define MXDEXT 3		/* directly accessible extents */
/* NOTE: Contrary to an assumption made in Teller's proposal to /usr/group,
   these extents do not remain directly accessible (i.e. no indirect blocks)
   if the file grows beyond three extents.  */
