/* values.h 
 * -- Defines useful values mandated by SYSTEM V Interface Definition
 */
#define BITSPERBYTE 8
#define BITS(_T_) (BITSPERBYTE * sizeof(_T_))
#define MAXSHORT 0x7FFF
#define MAXINT 0x7FFFFFFF
#define MAXLONG MAXINT
#define HIBITS ((short)0x8000)
#define HIBITI ((int)0x80000000)
#define HIBITL HIBITI
/* float favorites */
#define DMAXEXP	308
#define FMAXEXP 38
#define DMINEXP -324
#define FMINEXP -45
#define MAXDOUBLE 1.797693134862315E+308  /*  Largest value of a double.*/
#define MAXFLOAT 3.402823E+38	/*  Largest value of a float.  */
#define MINDOUBLE 4.940656458412466E-324  /*  Smallest positive double.  */
#define MINFLOAT 1.401298E-45	/*  Smallest positive float (DENORM).  */
#define DSIGNIF 16
#define FSIGNIF 7
	/* These MAXPOWTWO's are the maximum powers of two representable
	 * both exactly AND UNIQUELY in floating point representation
	 */
			/* compute 2^52 as a double (no ** op) */
#define DMAXPOWTWO ( (double)(1 << 30) * (1 << 22))
#define FMAXPOWTWO ( (double)(1 << 23))	/* 2^23 */
#define _FEXPLEN 8
#define _EXPBASE 2
#define _DEXPLEN 11
#define _IEEE 1		/* 1 if IEEE standard representation is used */
#define _LENBASE 1
#define HIDDENBIT 1	/* 1 if high-significance bit of mantissa is implied*/
#define _HIDDENBIT HIDDENBIT /* This name demanded by a SVR2 tool */
	/* some constants */
#define M_PI	3.141592653589793238
#define M_LN2	0.693147180559945309	/* ln(2) */
#define M_SQRT2	1.414213562373095049
/* Euler's constant is 0.57721 56649 01533 86061... */
/* The Golden Ratio is 1.61803 39887 49894 45868... */
#define LN_MAXDOUBLE (M_LN2 * DMAXEXP)
#define LN_MINDOUBLE (M_LN2 * (DMINEXP - 1))
/* Estimates on maximum precision */
#define H_PREC	(1L << DSIGNIF/2)	/* A reasonably precise value */
#define X_EPS	(1.0/H_PREC)
#define X_PLOSS	((double)(long)(M_PI * H_PREC)) /* Partial loss of sig. */
#define X_TLOSS	(M_PI * DMAXPOWTWO)	/* Any larger cannot be represented */
					/* exactly */

