unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, LCLintf,
  StdCtrls, ExtCtrls, ComCtrls;

type
  TPaintTest = class (TCustomControl)
  protected
    procedure paint; override;
  private
    t : TTimer;
    ScrollBar : TScrollBar;
  public
    constructor Create(AOwner: TComponent); override;
    procedure invalidateTest(Sender:TObject);
  end;

  { TForm1 }

  TForm1 = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
var t : TPaintTest;
begin
  writeln('FormCreate');
  width := 600; height := 600;
  t := TPaintTest.Create(self);
  t.Parent := panel1;
end;

constructor TPaintTest.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  // with this scroll bar, Canvas.ClipRect always returns full area
  ScrollBar:= TScrollBar.Create(Self);
  ScrollBar.Kind := sbVertical;  ScrollBar.Align := alRight;
  ScrollBar.LargeChange := 100;  ScrollBar.Max := 1000;
  ScrollBar.Parent := Self;

  self.width := 500; self.height := 500;
  t := TTimer.create(self);  t.interval := 1000;
  t.onTimer := @invalidateTest;  t.enabled := true;
end;

procedure TPaintTest.paint;
var r : TRect;
begin
  r := Canvas.ClipRect;
  writeln ('Paint ClipRect: Top:',r.top,' Right: ',r.right,' Bottom: ',R.Bottom,' Left:',r.Left);
end;

procedure TPaintTest.invalidateTest(Sender:TObject);
var r : TRect;
begin
  r.top := 0; r.Left:=0; r.Right:=10; r.Bottom:=10;
  if assigned(Parent) then
    InvalidateRect(Handle, @r, FALSE);
end;



{$R *.lfm}

end.

